<!-- Start Navbar Area -->
<?php
    $settingValue = getSettingValue();
?>
<header class="position-relative">
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-1 col-4">
                <a href="<?php echo e(url('/')); ?>" class="header-logo">
                    <img src="<?php echo e(asset(getLogoUrl())); ?>" alt="Infy HMS" class="img-fluid" />
                </a>
            </div>
            <div class="col-lg-11 col-8 ps-0">
                <nav class="navbar navbar-expand-xl navbar-light justify-content-end py-0">
                    <button class="navbar-toggler border-0 p-0" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false"
                            aria-label="Toggle navigation">
                        <span class="navbar-toggler-icon"></span>
                    </button>
                    <div class="collapse navbar-collapse justify-content-end" id="navbarNav">
                        <ul class="navbar-nav align-items-center py-2 py-lg-0">
                            <li class="nav-item">
                                <a class="nav-link <?php echo e(Request::is('/') ? 'active' : ''); ?>" aria-current="page" href="<?php echo e(url('/')); ?>">
                                    <?php echo e(__('messages.web_home.home')); ?>

                                </a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link <?php echo e(Request::is('our-services') ? 'active' : ''); ?>" href="<?php echo e(route('our-services')); ?>">
                                    <?php echo e(__('messages.web_home.services')); ?>

                                </a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('our-doctors')); ?>"
                                   class="nav-link <?php echo e(Request::is('our-doctors','doctor-details*') ? 'active' : ''); ?>"><?php echo e(__('messages.web_home.doctors')); ?></a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('aboutUs')); ?>"
                                   class="nav-link <?php echo e(Request::is('about-us') ? 'active' : ''); ?>"><?php echo e(__('messages.web_menu.about')); ?></a>
                            </li>

                            <li class="nav-item">
                                <a href="<?php echo e(route('contact')); ?>"
                                   class="nav-link <?php echo e(Request::is('contact-us') ? 'active' : ''); ?>"><?php echo e(__('messages.web_home.contact')); ?></a>
                            </li>

                            <li class="nav-item">
                                <a class="nav-link" href="#" <?php echo e(Request::is('terms-of-service', 'privacy-policy') ? 'active' : ''); ?>>
                                    <?php echo e(__('messages.web_menu.our_features')); ?>

                                    <i class="fa-solid fa-angle-down ms-1"></i>
                                </a>
                                <ul class="nav submenu">
                                    <li class="nav-item">
                                        <a class="nav-link <?php echo e(Request::is('appointment') ? 'active' : ''); ?>" href="<?php echo e(route('appointment')); ?>">
                                            <?php echo e(__('messages.web_menu.appointment')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item ">
                                        <a class="nav-link <?php echo e(Request::is('working-hours') ? 'active' : ''); ?>" href="<?php echo e(route('working-hours')); ?>">
                                            <?php echo e(__('messages.web_menu.working_hours')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link <?php echo e(Request::is('testimonial') ? 'active' : ''); ?>" href="<?php echo e(route('testimonials')); ?>">
                                            <?php echo e(__('messages.web_home.testimonials')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link <?php echo e(Request::is('terms-of-service') ? 'active' : ''); ?>" href="<?php echo e(route('terms-of-service')); ?>">
                                            <?php echo e(__('messages.web_home.terms_of_service')); ?>

                                        </a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link <?php echo e(Request::is('privacy-policy') ? 'active' : ''); ?>" href="<?php echo e(route('privacy-policy')); ?>">
                                            <?php echo e(__('messages.web_home.privacy_policy')); ?>

                                        </a>
                                    </li>
                                </ul>
                            </li>
                            <li class="nav-item">

                                <a class="nav-link" href="javascript:void(0)"> <?php echo e(__('messages.language.'.getCurrentLanguageName())); ?></a>
                                <ul class="nav submenu language-menu">
                                    <?php $__currentLoopData = getLanguages(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php $__currentLoopData = \App\Models\User::LANGUAGES_IMAGE; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $imageKey=> $imageValue): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <?php if($imageKey == $key): ?>
                                                <li class="nav-item languageSelection" data-prefix-value="<?php echo e($key); ?>">
                                                    <a href="javascript:void(0)" class="nav-link d-flex align-items-center">
                                                        <img class="me-2 country-flag"
                                                             src="<?php echo e(asset($imageValue)); ?>"/>
                                                        <?php echo e($value); ?></a>
                                                </li>
                                            <?php endif; ?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </ul>
                            </li>
                        </ul>
                        <div class="text-xl-end header-btn-grp ms-xl-3">
                            <?php if(Auth::user()): ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Admin')): ?>
                                    <a href="<?php echo e(route('dashboard')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Patient')): ?>
                                    <a href="<?php echo e(url('patient-dashboard')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Doctor')): ?>
                                    <a href="<?php echo e(url('employee/doctor')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Nurse')): ?>
                                    <a href="<?php echo e(url('bed-types')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Receptionist')): ?>
                                    <a href="<?php echo e(url('appointments')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Pharmacist')): ?>
                                    <a href="<?php echo e(url('employee/doctor')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Accountant')): ?>
                                    <a href="<?php echo e(url('accounts')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                                <?php if(\Spatie\Permission\PermissionServiceProvider::bladeMethodWrapper('hasRole', 'Case Manager')): ?>
                                    <a href="<?php echo e(url('employee/doctor')); ?>"
                                       data-turbo="false"
                                       class="btn btn-success me-2 mb-3 mb-xl-0"><?php echo e(__('messages.dashboard.dashboard')); ?>

                                    </a>
                                <?php endif; ?>
                            <?php else: ?>
                                <a href="<?php echo e(route('login')); ?>"
                                   data-turbo="false"
                                        class="btn btn-success me-2 mb-3 mb-xl-0">
                                    <?php echo e(__('messages.web_menu.login')); ?>

                                </a>
                            <?php endif; ?>
                                <a href="<?php echo e(route('appointment')); ?>" class="btn btn-primary mb-3 mb-xl-0">
                                    <?php echo e(__('messages.web_home.book_appointment')); ?>

                                </a>
                        </div>
                    </div>
                </nav>
            </div>
        </div>
    </div>
</header>
<!-- End Navbar Area -->
<?php /**PATH /home/niconorg/allaboutali.nicon.org.pk/resources/views/web/layouts/header.blade.php ENDPATH**/ ?>