<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.user.password')); ?> <?php echo e(__('messages.common.reset')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <!--begin::Authentication - Sign-up -->
    <?php
        $settingValue = getSettingValue();
        App::setLocale(checkLanguageSession());
    ?>

    <div class="d-flex flex-column flex-column-fluid align-items-center justify-content-center p-4">
        <div class="col-12 text-center">
            <a href="<?php echo e(route('front')); ?>" class="image mb-7 mb-sm-10">
                <img alt="Logo" src="<?php echo e($settingValue['app_logo']['value']); ?>" class="img-fluid logo-fix-size">
            </a>
        </div>
        <div class="width-540">
            <?php echo $__env->make('flash::message', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <?php if($errors->any()): ?>
                <div class="alert alert-danger">
                    <ul class="mb-0">
                        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($error); ?></li>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </ul>
                </div>
            <?php endif; ?>
        </div>
        <div class="bg-white rounded-15 shadow-md width-540 px-5 px-sm-7 py-10 mx-auto">
            <h1 class="text-center mb-7"><?php echo e(__('auth.reset_password.title')); ?></h1>
            <form method="POST" action="<?php echo e(url('/password/reset')); ?>">
                <?php echo csrf_field(); ?>
                <input type="hidden" name="token" value="<?php echo e($token); ?>">
                <div class="row">
                    <div class="mb-sm-7 mb-4">
                        <label for="email" class="form-label">
                            <?php echo e(__('auth.email') . ':'); ?><span class="required"></span>
                        </label>
                        <input name="email" type="email" class="form-control" id="email" aria-describedby="email"
                            placeholder=" <?php echo e(__('auth.email')); ?>" value="<?php echo e(old('email')); ?>" required>
                    </div>
                </div>
                <div class="row">
                    <div class="mb-sm-7 mb-4">
                        <label for="password" class="form-label">
                            <?php echo e(__('auth.password') . ':'); ?><span class="required"></span>
                        </label>
                        <div class="mb-3 position-relative">
                            <input type="password" name="password" class="form-control" id="password"
                                placeholder=" <?php echo e(__('auth.password')); ?>" aria-describedby="password" required
                                aria-label="Password" data-toggle="password">
                        </div>
                    </div>
                </div>
                <div class="row">
                    <div class="mb-sm-7 mb-4">
                        <label for="password_confirmation" class="form-label">
                            <?php echo e(__('auth.confirm_password') . ':'); ?><span class="required"></span>
                        </label>
                        <div class="mb-3 position-relative">
                            <input name="password_confirmation" type="password" class="form-control"
                                placeholder=" <?php echo e(__('auth.confirm_password')); ?>" id="password_confirmation"
                                aria-describedby="confirmPassword" required aria-label="Password" data-toggle="password">
                        </div>
                    </div>
                </div>
                <div class="d-grid">
                    <button type="submit" class="btn btn-primary"><?php echo e(__('auth.reset_password.reset_pwd_btn')); ?></button>
                </div>
                <div class="d-flex align-items-center mt-4">
                    <span class="text-gray-700 me-2"><?php echo e(__('auth.reset_password.already_reset')); ?></span>
                    <a href="<?php echo e(route('login')); ?>" class="link-info fs-6 text-decoration-none">
                        <?php echo e(__('auth.sign_in')); ?>

                    </a>
                </div>
            </form>
        </div>
    </div>
<?php $__env->stopSection(); ?>











































































<?php echo $__env->make('layouts.auth_app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iankim/public_html/resources/views/auth/passwords/reset.blade.php ENDPATH**/ ?>