<div id="add_vaccinated_patient_modal" class="modal fade" role="dialog" tabindex="-1" aria-hidden="true">
    <div class="modal-dialog modal-lg">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title" id="exampleModalLabel">
                    <?php echo e(__('messages.vaccinated_patient.new_vaccinate_patient')); ?></h3>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <?php echo e(Form::open(['id' => 'add_vaccinated_patient_form'])); ?>

            <div class="modal-body">
                <div class="alert alert-danger d-none hide" id="validationErrorsBox"></div>
                <div class="row">
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('patient_id', __('messages.vaccinated_patient.patient') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::select('patient_id', $patients, null, ['class' => 'form-control', 'required', 'id' => 'vPatientName', 'placeholder' => __('messages.document.select_patient'), 'data-control' => 'select2'])); ?>

                    </div>
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('vaccination_id', __('messages.vaccinated_patient.vaccine') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::select('vaccination_id', $vaccinations, null, ['class' => 'form-control', 'required', 'id' => 'vPatientVaccinationName', 'placeholder' => 'Select Vaccination', 'data-control' => 'select2'])); ?>

                    </div>

                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('vaccination_serial_number', __('messages.vaccinated_patient.serial_no') . ':', ['class' => 'form-label'])); ?>

                        <?php echo e(Form::text('vaccination_serial_number', '', ['placeholder' => __('messages.vaccinated_patient.serial_no'),'id' => 'vPatientSerialNo', 'class' => 'form-control'])); ?>

                    </div>

                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('dose_number', __('messages.vaccinated_patient.does_no') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::number('dose_number', '', ['placeholder' => __('messages.vaccinated_patient.does_no'),'id' => 'vPatientBrand', 'class' => 'form-control', 'min' => '1', 'max' => '50', 'minlength' => '1', 'maxlength' => '2', 'required'])); ?>

                    </div>
                    <?php $currentLang = app()->getLocale() ?>
                    <div class="form-group col-sm-6 mb-5">
                        <?php echo e(Form::label('dose_given_date', __('messages.vaccinated_patient.dose_given_date') . ':', ['class' => $currentLang == 'es' ? 'label-display form-label mb-3' : 'form-label mb-3'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('dose_given_date', '', ['placeholder' => __('messages.vaccinated_patient.dose_given_date'),'id' => 'vPatientDoesGivenDate', 'class' => getLoggedInUser()->thememode ? 'bg-light form-control' : 'bg-white form-control', 'required', 'autocomplete' => 'off'])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('description', __('messages.document.notes') . ':', ['class' => 'form-label fs-6 mb-3'])); ?>

                        <?php echo e(Form::textarea('description', null, ['placeholder' => __('messages.document.notes'),'class' => 'form-control', 'rows' => 4])); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer pt-0">
                <?php echo e(Form::button(__('messages.common.save'), ['type' => 'submit', 'class' => 'btn btn-primary me-5', 'id' => 'vPatientBtnSave', 'data-loading-text' => "<span class='spinner-border spinner-border-sm'></span> Processing..."])); ?>

                <button type="button" class="btn btn-secondary"
                    data-bs-dismiss="modal"><?php echo e(__('messages.common.cancel')); ?></button>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/niconorg/allaboutali.nicon.org.pk/resources/views/vaccinated_patients/add_modal.blade.php ENDPATH**/ ?>