<!doctype html>
<html lang="<?php echo e(str_replace('_', '-', getCurrentLanguageName())); ?>">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="title" content="<?php echo e(config('app.name')); ?>">

    <meta name="keywords" content="Hospital Management System" />

    <meta name="description" content="Hospital Management System | HMS" />
    <meta name="author" content="<?php echo e(getAppName()); ?>">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="turbo-cache-control" content="no-cache">
    <title><?php echo $__env->yieldContent('title'); ?> | <?php echo e(getAppName()); ?></title>
    <?php
        $settingValue = getSettingValue();
    ?>
    <link rel="icon" href="<?php echo e($settingValue['favicon']['value']); ?>" type="image/png">
    
    
    
    
    
    
    
    
    
    
    
    <link rel="stylesheet" href="<?php echo e(mix('css/front-third-party.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(mix('css/front-pages.css')); ?>">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.css" />
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
    <?php echo $__env->yieldContent('page_css'); ?>
    <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::styles(); ?>

    <?php echo $__env->yieldContent('css'); ?>
    <!-- Links of JS files -->
       <?php echo \Livewire\Mechanisms\FrontendAssets\FrontendAssets::scripts(); ?>


    
    
    <script src="https://cdn.jsdelivr.net/gh/livewire/turbolinks@v0.1.x/dist/livewire-turbolinks.js"
        data-turbolinks-eval="false" data-turbo-eval="false"></script>
    <script src='https://www.google.com/recaptcha/api.js'></script>
    <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit"></script>
    
    <script src="<?php echo e(mix('js/front-third-party.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/moment.js/2.29.1/moment.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="<?php echo e(asset('messages.js')); ?>"></script>
    <?php echo app('Tightenco\Ziggy\BladeRouteGenerator')->generate(); ?>
    
    <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
    <script src="<?php echo e(mix('js/front-pages.js')); ?>"></script>
    <?php echo $__env->yieldContent('page_scripts'); ?>
    <script>
        $(document).ready(function() {
            $(this).scrollTop(0)
            $('.alert').delay(5000).slideUp(300)
            // $('.selectize-dropdown').addClass('d-none');
        })

        $(document).on('click', '.doctor-name-filter', function() {
            $('.selectize-dropdown').removeClass('d-none')
        })
        $(document).on('click', '.languageSelection', function() {
            let languageName = $(this).data('prefix-value')

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content'),
                },
                type: 'POST',
                url: '/change-language',
                data: {
                    languageName: languageName
                },
                success: function() {
                    location.reload()
                },
            })
        })
    </script>
    <?php echo $__env->yieldContent('scripts'); ?>
</head>

<body>
    
    <?php echo $__env->make('web.layouts.header', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    <?php echo e(Form::hidden('userCurrentLanguage', checkLanguageSession(), ['class' => 'userCurrentLanguage'])); ?>

    <?php echo e(Form::hidden('invalidNumber', __('messages.common.invalid_number'), ['class' => 'invalidNumber'])); ?>

    <?php echo e(Form::hidden('invalidCountryNumber', __('messages.common.invalid_country_code'), ['class' => 'invalidCountryNumber'])); ?>

    <?php echo e(Form::hidden('tooShort', __('messages.common.too_short'), ['class' => 'tooShort'])); ?>

    <?php echo e(Form::hidden('tooLong', __('messages.common.too_long'), ['class' => 'tooLong'])); ?>

    <?php echo e(Form::hidden('invalidNumber', __('messages.common.invalid_number'), ['class' => 'invalidNumber'])); ?>

    <?php echo e(Form::hidden('invalidNumber', __('messages.common.invalid_number'), ['class' => 'invalidNumber'])); ?>

    <?php echo $__env->yieldContent('content'); ?>
    <?php echo $__env->make('web.layouts.footer', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

    <!-- Start Go Top Area -->
    <div class="go-top bg-success d-flex align-items-center justify-content-center">
        <i class="fas fa-chevron-up next-arrow"></i>
    </div>
</body>

</html>
<?php /**PATH /home/iankim/public_html/resources/views/web/layouts/front.blade.php ENDPATH**/ ?>