<?php $__env->startSection('title'); ?>
    <?php echo e(__('messages.appointment.new_appointment')); ?>

<?php $__env->stopSection(); ?>
<?php $__env->startSection('header_toolbar'); ?>
    <div class="container-fluid">
        <div class="d-md-flex align-items-center justify-content-between mb-7">
            <h1 class="mb-0"><?php echo $__env->yieldContent('title'); ?></h1>
            <a href="<?php echo e(route('appointments.index')); ?>"
               class="btn btn-outline-primary"><?php echo e(__('messages.common.back')); ?></a>
        </div>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('content'); ?>
    <div class="container-fluid">
        <div class="d-flex flex-column">
            <div class="row">
                <div class="col-12">
                    <?php echo $__env->make('layouts.errors', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    <div class="alert alert-danger d-none hide" id="createAppointmentErrorsBox"></div>
                </div>
            </div>
            <div class="card">
                <?php echo e(Form::hidden('doctorDepartmentUrl', url('doctors-list'), ['class' => 'doctorDepartmentUrl'])); ?>

                <?php echo e(Form::hidden('doctorChargeUrl', url('doctors-appointment-charge'), ['class' => 'doctorChargeUrl'])); ?>

                <?php echo e(Form::hidden('doctorScheduleList', url('doctor-schedule-list'), ['class' => 'doctorScheduleList'])); ?>

                <?php echo e(Form::hidden('appointmentSaveUrl', route('appointments.store'), ['id' => 'saveAppointmentURLID'])); ?>

                <?php echo e(Form::hidden('appointmentIndexPage', route('appointments.index'), ['class' => 'appointmentIndexPage'])); ?>

                <?php echo e(Form::hidden('isEdit', false, ['class' => 'isEdit'])); ?>

                <?php echo e(Form::hidden('isCreate', true, ['class' => 'isCreate'])); ?>

                <?php echo e(Form::hidden('getBookingSlot', route('get.booking.slot'), ['class' => 'getBookingSlot'])); ?>

                <div class="card-body p-12">
                    <?php echo e(Form::open(['id' => 'creatAppointmentForm'])); ?>


                    <?php echo $__env->make('appointments.fields', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                    <?php echo e(Form::close()); ?>

                </div>
            </div>
        </div>
        <?php echo $__env->make('appointments.templates.appointment_slot', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
    </div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="https://js.stripe.com/v3/"></script>
    <script src="https://checkout.razorpay.com/v1/checkout.js"></script>
    <script>
        let appointmentOptions = {
            'key': "<?php echo e(getPaymentCredentials('razorpay_key')); ?>",
            'amount': 0,
            'currency': "<?php echo e(strtoupper(getCurrentCurrency())); ?>",
            'name': "<?php echo e(getAppName()); ?>",
            'order_id': '',
            'description': '',
            'image': "<?php echo e(asset(getLogoUrl())); ?>",
            'callback_url': "<?php echo e(route('appointment.razorpay.success')); ?>",
            'prefill': {
                'appointment_id' :'',
                'amount' : '',
                'payment_mode' : '',
            },
            'theme': {
                'color': '#FF8E4B',
            },
            'modal': {
                'ondismiss': function() {
                    // livewire.emit("refresh");
                    $.ajax({
                        type: 'POST',
                        url: route('appointment.razorpay.failed'),
                        data: $("#appointmentForm").serialize(),
                        success: function(result) {
                            if (result.success) {
                                displayErrorMessage(result.message);
                                setTimeout(function () {
                                    window.location.href = $(".appointmentIndexPage").val();
                                }, 2000);
                            }
                        },
                        error: function(result) {
                            displayErrorMessage(result.responseJSON.message)
                        },
                    });
                },
            }
        }
        let stripeKey = '';
        <?php if(getPaymentCredentials('stripe_key')): ?>
            stripeKey = Stripe('<?php echo e(getPaymentCredentials('stripe_key')); ?>');
        <?php endif; ?>
    </script>
    
    
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/iankim/public_html/resources/views/appointments/create.blade.php ENDPATH**/ ?>