<div id="edit_advanced_payments_modal" class="modal fade" role="dialog" aria-hidden="true">
    <div class="modal-dialog">
        <!-- Modal content-->
        <div class="modal-content">
            <div class="modal-header">
                <h2><?php echo e(__('messages.advanced_payment.edit_advanced_payment')); ?></h2>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <?php echo e(Form::open(['id' => 'editAdvancedPaymentsForm'])); ?>

            <?php echo e(Form::hidden('currency_symbol', getCurrentCurrency(), ['class' => 'currencySymbol'])); ?>

            <div class="modal-body">
                <div class="alert alert-danger d-none hide" id="editAdvancedPaymentErrorsBox"></div>
                <?php echo e(Form::hidden('advanced_payment_id', null, ['id' => 'advancePaymentId'])); ?>

                <div class="row">
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('patient_id', __('messages.advanced_payment.patient') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::select('patient_id', $patients ?? [], null, ['class' => 'form-select', 'id' => 'editPatientId', 'placeholder' => __('messages.document.select_patient'), 'required', 'data-control' => 'select2'])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('receipt_no', __('messages.advanced_payment.receipt_no') . ':', ['class' => 'form-label'])); ?>

                        <span class="required"></span>
                        <?php echo e(Form::text('receipt_no', null, ['class' => 'form-control', 'id' => 'editReceiptNo', 'required', 'readonly', 'placeholder' => __('messages.advanced_payment.receipt_no')])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('amount', __('messages.advanced_payment.amount') . ':', ['class' => 'form-label required'])); ?>

                        <?php echo e(Form::text('amount', null, ['class' => 'form-control price-input', 'id' => 'editAmount', 'required', 'onkeyup' => 'if (parseInt(this.value.replace(/[^\d.]/g, "")) > 1000000) this.value = this.value.slice(0, -1)', 'placeholder' => __('messages.advanced_payment.amount')])); ?>

                    </div>
                    <div class="form-group col-sm-12 mb-5">
                        <?php echo e(Form::label('date', __('messages.advanced_payment.date') . ':', ['class' => 'form-label required'])); ?>

                        <?php echo e(Form::text('date', null, ['class' => getLoggedInUser()->thememode ? 'bg-light form-control' : 'bg-white form-control', 'id' => 'editAdvancedPaymentDate', 'required', 'autocomplete' => 'off', 'placeholder' => __('messages.advanced_payment.date')])); ?>

                    </div>
                </div>
            </div>
            <div class="modal-footer pt-0">
                <?php echo e(Form::button(__('messages.common.save'), ['type' => 'submit', 'class' => 'btn btn-primary m-0', 'id' => 'editAdvancedPaymentSave', 'data-loading-text' => "<span class='spinner-border spinner-border-sm'></span> Processing..."])); ?>

                <button type="button" class="btn btn-secondary"
                    data-bs-dismiss="modal"><?php echo e(__('messages.common.cancel')); ?></button>
            </div>
            <?php echo e(Form::close()); ?>

        </div>
    </div>
</div>
<?php /**PATH /home/iankim/public_html/resources/views/advanced_payments/edit_modal.blade.php ENDPATH**/ ?>