<div class="alert alert-danger d-none" id="customValidationErrorsBox"></div>
<div class="row">
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('first_name', __('messages.user.first_name') . ':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::text('first_name', null, ['class' => 'form-control','required', 'placeholder' => __('messages.user.first_name')])); ?>

        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('last_name', __('messages.user.last_name') . ':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::text('last_name', null, ['class' => 'form-control','required', 'placeholder' => __('messages.user.last_name')])); ?>

        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('email', __('messages.user.email') . ':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::email('email', null, ['class' => 'form-control','required','id'=>'createAccountantEmail', 'placeholder' => __('messages.user.email')])); ?>

        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('phone', __('messages.user.phone') . ':', ['class' => 'form-label'])); ?>

            <br>
            <?php echo e(Form::tel('phone', getCountryCode(), ['class' => 'form-control phoneNumber', 'id' => 'phoneNumber', 'onkeyup' => 'if (/\D/g.test(this.value)) this.value = this.value.replace(/\D/g,"")'])); ?>

            <?php echo e(Form::hidden('prefix_code', null, ['class' => 'prefix_code'])); ?>

            <span class="valid-msg text-success d-none fw-400 fs-small mt-2">✓ &nbsp; <?php echo e(__('messages.valid')); ?></span>
            <span class="error-msg text-danger d-none fw-400 fs-small mt-2"></span>
        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('blood_group', __('messages.user.blood_group') . ':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::select('blood_group', $bloodGroup, null, ['class' => 'form-select', 'id' => 'bloodGroup', 'placeholder' => __('messages.user.select_blood_group'), 'data-control' => 'select2'])); ?>

        </div>
    </div>
    <div class="col-md-6 mb-5">
        <?php echo e(Form::label('designation', __('messages.user.designation') . ':', ['class' => 'form-label'])); ?>

        <span class="required"></span>
        <?php echo e(Form::text('designation', null, ['class' => 'form-control','required', 'placeholder' => __('messages.user.designation')])); ?>

    </div>
    <div class="col-md-6 mb-5">
        <?php echo e(Form::label('qualification', __('messages.user.qualification') . ':', ['class' => 'form-label'])); ?>

        <span class="required"></span>
        <?php echo e(Form::text('qualification', null, ['class' => 'form-control','required', 'placeholder' => __('messages.user.qualification')])); ?>

    </div>
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('dob', __('messages.user.dob').':', ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('dob', null, ['class' => (getLoggedInUser()->thememode ? 'bg-light form-control' : 'bg-white form-control'),'id' => 'birthDate','autocomplete' => 'off', 'placeholder' => __('messages.user.dob')])); ?>

        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group mb-5">
            <?php echo e(Form::label('gender', __('messages.user.gender') . ':', ['class' => 'form-label'])); ?>

            <span class="required"></span> &nbsp;<br>
            <div class="d-flex align-items-center">
                <div class="form-check me-10">
                    <label class="form-label" for="accountantGenderMale"><?php echo e(__('messages.user.male')); ?></label>
                    <?php echo e(Form::radio('gender', '0', true, ['class' => 'form-check-input', 'id' => 'accountantGenderMale'])); ?>

                </div>
                <div class="form-check me-10">
                    <label class="form-label"
                        for="accountantGenderFemale"><?php echo e(__('messages.user.female')); ?></label>&nbsp;
                    <?php echo e(Form::radio('gender', '1', false, ['class' => 'form-check-input', 'id' => 'accountantGenderFemale'])); ?>

                </div>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group mb-5">
            <?php echo e(Form::label('status', __('messages.common.status') . ':', ['class' => 'form-label'])); ?>

            <br>
            <div class="form-check form-switch">
                <input class="form-check-input is-active" name="status" type="checkbox" value="1" tabindex="8"
                    checked>
            </div>
        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group mb-5">
            <?php echo e(Form::label('password', __('messages.user.password') . ':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::password('password', ['class' => 'form-control','required','min' => '6','max' => '10', 'placeholder' => __('messages.user.password')])); ?>

        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group mb-5">
            <?php echo e(Form::label('password_confirmation', __('messages.user.password_confirmation') . ':', ['class' => 'form-label'])); ?>

            <span class="required"></span>
            <?php echo e(Form::password('password_confirmation', ['class' => 'form-control','required','min' => '6','max' => '10', 'placeholder' => __('messages.user.password_confirmation')])); ?>

        </div>
    </div>
    <div class="form-group col-md-4 mb-5">
        <div class="row2" io-image-input="true">
            <?php echo e(Form::label('image', __('messages.common.profile') . ':', ['class' => 'form-label'])); ?>



            <div class="d-block">
                <?php
                $style = 'style=';
                $background = 'background-image:';
                ?>

                <div class="image-picker">
                    <div class="image previewImage" id="previewImage" <?php echo e($style); ?>"<?php echo e($background); ?>

                        url(<?php echo e(asset('assets/img/avatar.png')); ?>">
                        <span class="picker-edit rounded-circle text-gray-500 fs-small"
                            title="<?php echo e(__('messages.common.profile')); ?>">
                            <label>
                                <i class="fa-solid fa-pen" id="profileImageIcon"></i>
                                <input type="file" id="accountantProfileImage" name="image"
                                    class="image-upload d-none profileImage accountantProfileImage"
                                    accept=".png, .jpg, .jpeg, .gif" />
                                <input type="hidden" name="avatar_remove" />
                            </label>
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<div class="row mt-3">
    <div class="col-md-12 mb-3">
        <h5><?php echo e(__('messages.user.address_details')); ?></h5>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('address1',__('messages.user.address1').(':'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('address1', null, ['class' => 'form-control', 'placeholder' => __('messages.user.address1')])); ?>

        </div>
    </div>
    <div class="col-md-6">
        <div class="form-group mb-5">
            <?php echo e(Form::label('address2',__('messages.user.address2').(':'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('address2', null, ['class' => 'form-control', 'placeholder' => __('messages.user.address2')])); ?>

        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group mb-5">
            <?php echo e(Form::label('city',__('messages.user.city').(':'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('city', null, ['class' => 'form-control','placeholder' => __('messages.user.city')])); ?>

        </div>
    </div>
    <div class="col-md-3">
        <div class="form-group mb-5">
            <?php echo e(Form::label('zip',__('messages.user.zip').(':'), ['class' => 'form-label'])); ?>

            <?php echo e(Form::text('zip', null, ['class' => 'form-control', 'maxlength' => '6','minlength' => '6','placeholder' => __('messages.user.zip')])); ?>

        </div>
    </div>
    <div class="d-flex justify-content-end">
        <?php echo e(Form::submit(__('messages.common.save'), ['class' => 'btn btn-primary me-2'])); ?>

        <a href="<?php echo e(route('accountants.index')); ?>"
            class="btn btn-secondary me-2"><?php echo e(__('messages.common.cancel')); ?></a>
    </div>
<?php /**PATH /home/iankim/public_html/resources/views/accountants/fields.blade.php ENDPATH**/ ?>