<div>
    <div class="tab-content" id="myTabContent">
        <div class="tab-pane fade show active" id="expenseOverview" role="tabpanel">
            <div class="card mb-5 mb-xl-10">
                <div class="card-header border-0">
                    <div class="card-title m-0">
                        <h3 class="fw-bolder m-0">{{ __('messages.expense.expense_details') }}</h3>
                    </div>
                </div>
                <div>
                    <div class="card-body  border-top p-9">
                        <div class="row mb-7">
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('name', __('messages.expense.name') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span class="fw-bolder fs-6 text-gray-800">{{ $expenses->name }}</span>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('expense_head', __('messages.expense.expense_head') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span
                                    class="fw-bolder fs-6 text-gray-800">{{ $expenseHeads[$expenses->expense_head] }}</span>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('invoice_number', __('messages.expense.invoice_number') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <p class="m-0">
                                    <span
                                        class="badge bg-light-info fs-6">{{ !empty($expenses->invoice_number) ? $expenses->invoice_number : __('messages.common.n/a') }}</span>
                                </p>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('date', __('messages.expense.date') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span
                                    class="fw-bolder fs-6 text-gray-800">{{ date('jS M, Y', strtotime($expenses->date)) }}</span>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('amount', __('messages.expense.amount') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span class="fw-bolder fs-6 text-gray-800"><b>{{ getCurrencySymbol() }}</b>
                                    {{ number_format($expenses->amount, 2) }}</span>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('attachment', __('messages.expense.attachment') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span class="fw-bolder fs-6 text-gray-800">
                                    @if (!empty($expenses->document_url))
                                        <a href="{{ $expenses->document_url }}"
                                            target="_blank">{{ __('messages.common.view') }}</a>
                                    @else
                                        {{ __('messages.common.n/a') }}
                                    @endif
                                </span>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('description', __('messages.expense.description') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span class="fw-bolder fs-6 text-gray-800">
                                    {!! !empty($expenses->description) ? nl2br(e($expenses->description)) : __('messages.common.n/a') !!}
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('created_at', __('messages.common.created_on') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span class="fw-bolder fs-6 text-gray-800"
                                    title="{{ date('jS M, Y', strtotime($expenses->created_at)) }}">{{ $expenses->created_at->diffForHumans() }}</span>
                            </div>
                            <div class="col-lg-4 col-md-4 col-sm-2 d-flex flex-column">
                                {{ Form::label('updated_at', __('messages.common.updated_at') . ':', ['class' => 'fw-bold text-muted py-3']) }}
                                <span class="fw-bolder fs-6 text-gray-800"
                                    title="{{ date('jS M, Y', strtotime($expenses->updated_at)) }}">{{ $expenses->updated_at->diffForHumans() }}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
