<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => '這 :attribute 必須接受.',
    'active_url' => '這 :attribute 不是有效的 URL.',
    'after' => '這 :attribute 必須是 :date 之後的日期.',
    'after_or_equal' => '這 :attribute 必須是 :date 之後或等於的日期.',
    'alpha' => '這 :attribute 只能包含字母.',
    'alpha_dash' => '這 :attribute 只能包含字母、數字、破折號和下劃線.',
    'alpha_num' => '這 :attribute 只能包含字母和數字.',
    'array' => '這attribute 必須是一個數組.',
    'before' => '這 :attribute 必須是 :date 之前的日期.',
    'before_or_equal' => '這 :attribute 必須是早於或等於 :date 的日期.',
    'between' => [
        'numeric' => '這 :attribute 必須介於 :min 和 :max 之間。',
        'file' => '這 :attribute 必須介於 :min 和 :max 千字節之間.',
        'string' => '這 :attribute 必須介於 :min 和 :max 字符之間.',
        'array' => '這 :attribute 必須在 :min 和 :max 之間的項目.',
    ],
    'boolean' => '這 :attribute 字段必須為真或假.',
    'confirmed' => '這 :attribute 確認不匹配.',
    'current_password' => '密碼不正確.',
    'date' => '這 :attribute 不是有效日期.',
    'date_equals' => '這 :attribute 必須是等於 :date 的日期.',
    'date_format' => '這 :attribute 與格式不匹配 :format.',
    'different' => '這 :attribute 和 :other 必須不同.',
    'digits' => '這 :attribute 必須是 :digits 數字.',
    'digits_between' => '這 :attribute 必須介於 :min 和 :max 數字之間.',
    'dimensions' => '這 :attribute 圖片尺寸無效.',
    'distinct' => '這 :attribute 字段具有重複值.',
    'email' => '這 :attribute 必須是一個有效的E-mail地址.',
    'ends_with' => '這 :attribute 必須以下列之一結尾: :values.',
    'exists' => '這 選擇 :attribute 是無效的.',
    'file' => '這 :attribute 必須是文件.',
    'filled' => '這 :attribute 字段必須有值.',
    'gt' => [
        'numeric' => '這 :attribute 必須大於 :value.',
        'file' => '這 :attribute 必須大於 :value 千字節.',
        'string' => '這 :attribute 必須大於 :value 字符。',
        'array' => '這 :attribute 必須有超過 :value 項.',
    ],
    'gte' => [
        'numeric' => '這 :attribute 必須大於或等於 :value。',
        'file' => '這 :attribute 必須大於或等於 :value 千字節。',
        'string' => '這 :attribute 必須大於或等於 :value 字符.',
        'array' => '這 :attribute 必須有 :value 項或更多.',
    ],
    'image' => '這 :attribute 必須是圖像.',
    'in' => '這 選擇 :attribute 是無效的.',
    'in_array' => '這 :attribute 字段不存在於 :other.',
    'integer' => '這 :attribute 必須是整數.',
    'ip' => '這 :attribute 必須是有效的 IP 地址.',
    'ipv4' => '這 :attribute 必須是有效的 IPv4 地址.',
    'ipv6' => '這 :attribute 必須是有效的 IPv6 地址.',
    'json' => '這 :attribute 必須是有效的 JSON 字符串.',
    'lt' => [
        'numeric' => '這 :attribute 必須小於 :value.',
        'file' => '這 :attribute 必須小於 :value 千字節.',
        'string' => '這 :attribute 必須小於 :value 個字符.',
        'array' => '這 :attribute 必須少於 :value 項.',
    ],
    'lte' => [
        'numeric' => '這 :attribute 必須小於或等於 :value.',
        'file' => '這 :attribute 必須小於或等於 :value 千字節.',
        'string' => '這 :attribute 必須小於或等於 :value 個字符.',
        'array' => '這 :attribute 不得超過 :value 項.',
    ],
    'max' => [
        'numeric' => '這 :attribute 不得大於 :max.',
        'file' => '這 :attribute 不得大於 :max 千字節.',
        'string' => '這 :attribute 不得大於 :max 個字符.',
        'array' => '這 :attribute 不得超過 :max 個項目.',
    ],
    'mimes' => '這 :attribute 必須是文件類型: :values.',
    'mimetypes' => '這 :attribute 必須是文件類型: :values.',
    'min' => [
        'numeric' => '這 :attribute 必須至少為 :min.',
        'file' => '這 :attribute 必須至少為 :min 千字節.',
        'string' => '這 :attribute 必須至少為 :min 個字符.',
        'array' => '這 :attribute 必須至少有 :min 個項目.',
    ],
    'multiple_of' => '這 :attribute 必須是 :value 的倍數.',
    'not_in' => '這 選擇 :attribute 是無效的.',
    'not_regex' => '這 :attribute 格式無效.',
    'numeric' => '這 :attribute 必須是數字.',
    'password' => '密碼不正確.',
    'present' => '這 :attribute 字段必須存在.',
    'regex' => '這 :attribute 格式無效.',
    'required' => '這 :attribute 字段是必需的。',
    'required_if' => '這 :attribute 當 :other 為 :value 時，該字段是必需的.',
    'required_unless' => '這 :attribute 除非 :other 在 :values 中，否則字段是必需的.',
    'required_with' => '這 :attribute 存在 :values 時需要字段.',
    'required_with_all' => '這 :attribute 當 :values 存在時，字段是必需的.',
    'required_without' => '這 :attribute 當 :values 不存在時，該字段是必需的.',
    'required_without_all' => '這 :attribute 當沒有 :values 時，字段是必需的.',
    'prohibited' => '這 :attribute 字段被禁止。',
    'prohibited_if' => '這 :attribute 當 :other 為 :value 時，字段被禁止.',
    'prohibited_unless' => '這 :attribute 除非 :other 在 :values 中，否則禁止字段.',
    'same' => '這 :attribute 和 :other 必須匹配.',
    'size' => [
        'numeric' => '這 :attribute 必須是：大小.',
        'file' => '這 :attribute 必須是 :size 千字節.',
        'string' => '這 :attribute 必須是 :size 個字符。',
        'array' => '這 :attribute 必須包含 :size 項目.',
    ],
    'starts_with' => '這 :attribute 必須以下列之一開頭： :values.',
    'string' => '這 :attribute 必須是字符串.',
    'timezone' => '這 :attribute 必須是有效的時區.',
    'unique' => '這 :attribute 已有人帶走了.',
    'uploaded' => '這 :attribute 上傳失敗.',
    'url' => '這 :attribute 必須是有效的 URL。',
    'uuid' => '這 :attribute 必須是有效的 UUID。',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => '自定义消息',
        ],

        //doctor opd charge keys
        'doctor_id' => [
            'unique' => '医生的名字已经被使用。',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'email' => __('messages.user.email'),
        'last_name' => __('messages.user.last_name'),
        'first_name' => __('messages.user.first_name'),
        'password' => __('messages.department'),
        'gender' => __('messages.user.gender'),
        'city' => __('messages.user.city'),
        'zip' => __('messages.user.zip'),
        'name' => __('messages.common.name'),
        'status' => __('messages.account.status'),
        'description' => __('messages.account.description'),
        'patient_id' => __('messages.invoice.patient_id'),
        'receipt_no' => __('messages.advanced_payment.receipt_no'),
        'amount' => __('messages.advanced_payment.amount'),
        'date' => __('messages.advanced_payment.date'),
        'vehicle_number' => __('messages.ambulance.vehicle_number'),
        'vehicle_model' => __('messages.ambulance.vehicle_model'),
        'driver_contact' => __('messages.ambulance.driver_contact'),
        'year_made' => __('messages.ambulance.year_made'),
        'driver_license' => __('messages.ambulance.driver_license'),
        'doctor_id' => __('messages.ipd_patient.doctor_id'),
        'opd_date' => __('messages.appointment.opd_date'),
        'bed_type' => __('messages.bed.bed_type'),
        'charge' => __('messages.bed.charge'),
        'bed_id' => __('messages.bed.bed_id'),
        'case_id' => __('messages.bed_assign.case_id'),
        'assign_date' => __('messages.bed_assign.assign_date'),
        'discharge_date' => __('messages.bed_assign.discharge_date'),
        'title' => __('messages.document.title'),
        'bill_date' => __('messages.bill.bill_date'),
        'qty' => __('messages.bill.qty'),
        'price' => __('messages.bill.price'),
        'blood_group' => __('messages.user.blood_group'),
        'remained_bags' => __('messages.hospital_blood_bank.remained_bags'),
        'bags' => __('messages.blood_donation.bags'),
        'last_donate_date' => __('messages.blood_donation.last_donate_date'),
        'issue_date' => __('messages.blood_issue.issue_date'),
        'remarks' => __('messages.blood_issue.remarks'),
        'charge_type' => __('messages.charge_category.charge_type'),
        'code' => __('messages.charge.code'),
        'standard_charge' => __('messages.charge.standard_charge'),
        'currency_name' => __('messages.currency.currency_name'),
        'currency_code' => __('messages.currency.currency_code'),
        'currency_icon' => __('messages.currency.currency_icon'),
        'sr_no' => __('messages.employee_payroll.sr_no'),
        'payroll_id' => __('messages.employee_payroll.payroll_id'),
        'type' => __('messages.account.type'),
        'month' => __('messages.employee_payroll.month'),
        'year' => __('messages.employee_payroll.year'),
        'net_salary' => __('messages.employee_payroll.net_salary'),
        'basic_salary' => __('messages.employee_payroll.basic_salary'),
        'message' => __('messages.enquiry.message'),
        'expense_head' => __('messages.expense.expense_head'),
        'invoice_number' => __('messages.expense.invoice_number'),
        'short_description' => __('messages.short_description'),
        'about_us_title' => __('messages.front_setting.about_us_title'),
        'about_us_mission' => __('messages.front_setting.about_us_mission'),
        'about_us_image' => __('messages.front_setting.about_us_image'),
        'income_head' => __('messages.incomes.income_head'),
        'service_tax' => __('messages.insurance.service_tax'),
        'insurance_no' => __('messages.insurance.insurance_no'),
        'insurance_code' => __('messages.insurance.insurance_code'),
        'discount' => __('messages.insurance.discount'),
        'disease_name' => __('messages.insurance.diseases_name'),
        'disease_charge' => __('messages.insurance.diseases_charge'),
        'invoice_date' => __('messages.invoice.invoice_date'),
        'quantity' => __('messages.service.quantity'),
        'total_payments' => __('messages.dashboard.total_payments'),
        'gross_total' => __('messages.ipd_bill.gross_total'),
        'discount_in_percentage' => __('messages.ipd_bill.discount_in_percentage'),
        'tax_in_percentage' => __('messages.ipd_bill.tax_in_percentage'),
        'other_charges' => __('messages.ipd_bill.other_charges'),
        'net_payable_amount' => __('messages.ipd_bill.net_payable_amount'),
        'charge_type_id' => __('messages.ipd_patient_charges.charge_type_id'),
        'charge_category_id' => __('messages.ipd_patient_charges.charge_category_id'),
        'charge_id' => __('messages.ipd_patient_charges.charge_id'),
        'applied_charge' => __('messages.ipd_patient_charges.applied_charge'),
        'instruction' => __('messages.ipd_patient_consultant_register.instruction'),
        'instruction_date' => __('messages.ipd_patient_consultant_register.instruction_date'),
        'report_type' => __('messages.ipd_patient_diagnosis.report_type'),
        'report_date' => __('messages.ipd_patient_diagnosis.report_date'),
        'bed_type_id' => __('messages.ipd_patient.bed_type_id'),
        'weight' => __('messages.ipd_patient.weight'),
        'height' => __('messages.ipd_patient.height'),
        'bp' => __('messages.ipd_patient.bp'),
        'payment_mode' => __('messages.ipd_payments.payment_mode'),
        'notes' => __('messages.document.notes'),
        'category_id' => __('messages.ipd_patient_prescription.category_id'),
        'issued_by' => __('messages.issued_item.issued_by'),
        'issued_date' => __('messages.issued_item.issued_date'),
        'return_date' => __('messages.issued_item.return_date'),
        'unit' => __('messages.item.unit'),
        'consultation_title' => __('messages.live_consultation.consultation_title'),
        'consultation_date' => __('messages.live_consultation.consultation_date'),
        'consultation_duration_minutes' => __('messages.live_consultation.consultation_duration_minutes'),
        'type_number' => __('messages.live_consultation.type_number'),
        'to' => __('messages.common.to'),
        'subject' => __('messages.email.subject'),
        'selling_price' => __('messages.medicine.selling_price'),
        'buying_price' => __('messages.medicine.buying_price'),
        'side_effects' => __('messages.medicine.side_effects'),
        'salt_composition' => __('messages.medicine.salt_composition'),
        'appointment_date' => __('messages.opd_patient.appointment_date'),
        'rate' => __('messages.package.rate'),
        'test_name' => __('messages.radiology_test.test_name'),
        'short_name' => __('messages.radiology_test.short_name'),
        'test_type' => __('messages.radiology_test.test_type'),
        'policy_no' => __('messages.patient_admission.policy_no'),
        'fee' => __('messages.case.fee'),
        'payment_date' => __('messages.payment.payment_date'),
        'pay_to' => __('messages.payment.pay_to'),
        'from_title' => __('messages.postal.from_title'),
        'to_title' => __('messages.postal.to_title'),
        'reference_no' => __('messages.postal.reference_no'),
        'subcategory' => __('messages.radiology_test.subcategory'),
        'available_on' => __('messages.schedule.available_on'),
        'available_from' => __('messages.schedule.available_from'),
        'available_to' => __('messages.schedule.available_to'),
        'per_patient_time' => __('messages.schedule.per_patient_time'),
        'app_name' => __('messages.setting.app_name'),
        'company_name' => __('messages.setting.company_name'),
        'favicon' => __('messages.setting.favicon'),
        'zoom_api_key' => __('messages.live_consultation.zoom_api_key'),
        'zoom_api_secret' => __('messages.live_consultation.zoom_api_secret'),
        'dose_given_date' => __('messages.vaccinated_patient.dose_given_date'),
        'manufactured_by' => __('messages.vaccination.manufactured_by'),
        'brand' => __('messages.vaccination.brand'),
        'purpose' => __('messages.visitor.purpose'),
        'no_of_person' => __('messages.visitor.number_of_person'),
        'in_time' => __('messages.visitor.in_time'),
        'out_time' => __('messages.visitor.out_time'),
        'field_name' => __('messages.custom_field.field_name')
    ],

];
