<?php

return [

    /*
    |--------------------------------------------------------------------------
    | All Titles and static string in blade files - Chinese Language
    |--------------------------------------------------------------------------
    |
    */
    //menu.blade keys
    'admin' => '管理员',
    'admins' => '行政',
    'roles' => '的角色',
    'doctor_departments' => '医生科室',
    'nurses' => '护士',
    'operations' => '操作',
    'doctors' => '医生',
    'patients' => '耐心',
    'lab_technicians' => '实验室技术员',
    'receptionists' => '接待员',
    'pharmacists' => '药剂师',
    'accountants' => '会计师',
    'appointments' => '预约时间',
    'insurances' => '保险',
    'investigation_reports' => '调查报告',
    'death_reports' => '死亡报告',
    'birth_reports' => '出生报告',
    'operation_reports' => '营运报告',
    'medicine_categories' => '医药类别',
    'medicine_brands' => '医药品牌',
    'medicines' => '药品',
    'cases' => '案例',
    'case_handlers' => '案件处理人员',
    'bed_types' => '床型',
    'beds' => '床铺',
    'bed_assigns' => '床分配',
    'packages' => '配套',
    'schedules' => '时间表',
    'schedule_label' => '日程',
    'services' => '服务',
    'accounts' => '帐目',
    'payments' => '付款方式',
    'bills' => '账单',
    'employee_payrolls' => '员工工资单',
    'documents' => '文件资料',
    'document_types' => '文件类型',
    'notice_boards' => '公告栏',
    'settings' => '设定值',
    'doctors_list' => '医生名单',
    'my_payrolls' => '我的工资单',
    'blood_banks' => '血库',
    'blood_donors' => '献血者',
    'invoices' => '发票',
    'patients_cases' => '患者案例',
    'patients_case_details' => '患者病例详情',
    'account_manager' => '客户经理',
    'bed_management' => '床位管理',
    'blood_bank' => '血库',
    'billing' => '开票',
    'case_manager' => '个案经理',
    'cms' => '内容管理系统',
    'department' => '部门',
    'departments' => '部门',
    'hospital_activities' => '医院活动',
    'advanced_payments' => '预付款',
    'patient_admissions' => '病人入院',
    'appointment_calendar' => '委。 日历',
    'bed_mgt' => '床管理',
    'reports' => '报告书',
    'enquiries' => '咨询处',
    'mail' => '邮件',
    'ambulances' => '救护车',
    'ambulance_calls' => '救护车电话',
    'prescriptions' => '处方药',
    'hospital_charges' => '住院费用',
    'charge_categories' => '收费类别',
    'charges' => '收费标准',
    'radiologies' => '放射学',
    'radiology_categories' => '放射学 类别',
    'pathologies' => '病理',
    'pathology_categories' => '病理 类别',
    'radiology_tests' => '放射学检查',
    'doctor_opd_charges' => '医生OPD收费',
    'pathology_tests' => '病理检查',
    'expenses' => '花费',
    'income' => '收入',
    'finance' => '金融',
    'inventory' => '库存',
    'items_categories' => '项目类别',
    'items' => '物品',
    'items_stocks' => '物品库存',
    'issued_items' => '发行物品',
    'ipd_patients' => 'IPD患者',
    'ipd_opd' => '瞳距/瞳距',
    'ipd_diagnosis' => '诊断',
    'ipd_consultant_register' => '顾问指导',
    'ipd_consultant_doctor' => '顾问医生',
    'ipd_charges' => '收费标准',
    'ipd_prescription' => '处方药',
    'ipd_timelines' => '时间线',
    'ipd_payment' => '知识产权支付',
    'opd_patients' => 'OPD患者',
    'opd_diagnosis' => 'OPD诊断',
    'opd_timeline' => 'OPD 时间线',
    'call_logs' => '通话记录',
    'visitors' => '参观者',
    'front_office' => '前厅',
    'postal_receive' => '邮政收据',
    'postal_dispatch' => '邮政派遣',
    'general' => '一般',
    'sidebar_setting' => '模块设置',
    'currency_setting' => '货币',
    'testimonials' => '感言',
    'blood_donations' => '献血',
    'blood_issues' => '血液问题',
    'live_consultations' => '现场咨询',
    'vaccinations' => '預防接種',
    'vaccinated_patients' => '接種疫苗的患者',
    'users' => '用户数',
    'front_settings' => '正面设置',
    'front_service' => '前台服务',
    'about_us' => '关于我们',
    'make_an_appointment' => '预约',
    'patient_appointment' => '患者预约',
    'old_patient' => '老病人',
    'new_patient' => '新病人',
    'available_slot' => '可用插槽',
    'contact_us' => '联系我们',
    'live_meetings' => '实时会议',
    'live_meeting' => '现场会议',
    'hospital_schedule' => '住院时间表',
    'front_cms' => '前厘米',
    'front_cms_services' => '前端 CMS 服务',
    'facebook_url' => '脸书网址',
    'twitter_url' => '推特网址',
    'instagram_url' => 'Instagram 网址',
    'linkedIn_url' => '领英网址',
    'allow_file_type' => '允许的文件类型：png、jpg、jpeg。',
    'overview' => '概述',
    'no_data_available' => '表中无可用数据',
    'file_name' => '文件名',
    'icon' => '图标',
    'short_description' => '简短的介绍',
    'valid' => '有效的',
    'no_matching_records_found' => '未找到符合的記錄',
    'select_applied_date' => '請選擇申請日期',
    'select_instruction_date' => '請選擇授課日期',
    'report' => '報告',
    'report_id' => '報告編號',
    'yearly_income_expense_chart' => '年度收入支出表',
    'sms_mail' => '簡訊/郵件',
    'payment_gateways' => '支付网关',
    'stripe_key' => 'Stripe 密钥',
    'stripe_secret' => 'Stripe 密钥',
    'paypal' => 'PayPal',
    'paypal_client_id' => '貝寶客戶 ID',
    'paypal_secret' => 'PayPal 密钥',
    'paypal_mode' => '貝寶模式',
    'razorpay' => '剃须刀支付',
    'razorpay_key' => 'Razorpay 密钥',
    'razorpay_secret' => 'Razorpay 密钥',
    'cash' => '現金',
    'cheque' => '查看',
    'flutterwave' => '颤振波',
    'flutterwave_public_key' => 'Flutterwave 公钥',
    'flutterwave_secret_key' => 'Flutterwave 秘钥',
    'phonepe' => '電話號碼',
    'paystack' => '支付宝',
    'paystack_public_key' => 'Paystack公钥',
    'paystack_secret_key' => '支付宝秘密密钥',
    'phonepe_merchant_id' => 'Phonepe 商家 ID',
    'phonepe_merchant_user_id' => 'Phonepe 商家用戶 ID',
    'phonepe_env' => '電話環境',
    'phonepe_salt_key' => 'Phonepe 鹽鍵',
    'phonepe_salt_index' => 'Phonepe鹽指數',
    'phonepe_merchant_transaction_id' => 'Phonepe 商家交易 ID',

    'language' => [
        'Arabic' => '阿拉伯',
        'Chinese' => '中国人',
        'English' => '英语',
        'French' => '法语',
        'German' => '德语',
        'Portuguese' => '葡萄牙语',
        'Russian' => '俄语',
        'Spanish' => '西班牙语',
        'Turkish' => '土耳其',
    ],

    //roles
    'role' => [
        'new_role' => '新角色',
        'edit_role' => '编辑角色',
        'select_role' => '選擇角色',
    ],

    //user keys
    'user' => [
        'user' => '用户',
        'first_name' => '名字',
        'last_name' => '姓',
        'name' => '名称',
        'email' => '电子邮件',
        'phone' => '电话',
        'designation' => '指定',
        'gender' => '性别',
        'male' => '男',
        'female' => '女',
        'qualification' => '资质',
        'dob' => '出生日期',
        'blood_group' => '血型',
        'select_blood_group' => '选择血型',
        'password' => '密码',
        'password_confirmation' => '确认密码',
        'address1' => '地址1',
        'address2' => '地址2',
        'city' => '市',
        'zip' => '压缩',
        'address_details' => '详细地址',
        'address_not_found' => '找不到地址详细信息',
        'education' => '教育',
        'status' => '状态',
        'edit_profile' => '编辑个人资料',
        'change_password' => '更改密码',
        'logout' => '登出',
        'new_user' => '新用户',
        'edit_user' => '编辑用户',
        'user_details' => '使用者详细资料',
        'email_verified_successfully' => '邮箱验证成功。',
        'invalid_password' => '当前密码无效。',
        'validate_confirm_password' => '密码和确认密码必须匹配。',
        'validate_min_character_password' => '密码必须至少包含 6 个字符。',
        'validate_image_type' => '图片必须为以下文件类型之一：jpg、jpeg、png。',
        'validate_image_size' => '文档大小必须小于10 MB',
        'validate_facebook_url' => '请输入有效的 Facebook 链接',
        'validate_twitter_url' => '请输入有效的 Twitter 链接',
        'validate_instagram_url' => '请输入有效的 Instagram 链接',
        'validate_linkedin_url' => '请输入有效的 LinkedIn 链接',
        'user_list' => '用户列表',
        'phone_number_must_be_10_digits' => '電話號碼長度必須為 10 位數字',
        'valid_email' => '請輸入有效的電子郵件',
    ],

    //common keys
    'common' => [
        'field_required' => '欄位為必填欄位。',
        'change' => '改變',
        'change_profile' => '更改圖像',
        'is' => '是',
        'available_quantity_of' => '可用數量',
        'result' => '結果',
        'profile' => '轮廓',
        'status' => '状态',
        'action' => '行动',
        'save' => '保存',
        'cancel' => '取消',
        'canceled' => '取消',
        'back' => '背部',
        'created_on' => '创建于',
        'last_updated' => '最近更新时间',
        'n/a' => '不适用',
        'new' => '新',
        'total' => '总',
        'add' => '加',
        'active' => '活性',
        'name' => '名称',
        'edit' => '编辑',
        'detail' => '细节',
        'delete' => '删除',
        'view' => '视图',
        'view_attachment' => '查看附件',
        'de_active' => '停用',
        'description' => '描述',
        'created_at' => '创建于',
        'updated_at' => '最近更新时间',
        'is_available' => '有空',
        'choose' => '选择',
        'yes' => '是',
        'no' => '没有',
        'address' => '地址',
        'export_to_excel' => '输出到电子表格',
        'reset' => '重启',
        'actions' => '行动',
        'confirm' => '确认',
        'user_details' => '用户',
        'search' => '搜索',
        'status_updated_successfully' => '状态更新成功。',
        'saved_successfully' => '保存成功。',
        'updated_successfully' => '更新成功',
        'deleted_successfully' => '删除成功',
        'filter_options' => '过滤器选项',
        'are_you_sure_want_to_delete_this' => '你确定要删除这个 ',
        'deleted' => '已删除',
        'has_been_deleted' => '已被删除。',
        'cant_be_deleted' => '无法删除',
        'custom' => '风俗',
        'apply' => '申请',
        'from' => '从',
        'to' => '至',
        'invalid_number' => '无效号码',
        'invalid_country_code' => '国家代码无效',
        'too_short' => '太短',
        'too_long' => '太长',
        'not_found' => '未找到',
        'previous' => '以前的',
        'next' => '下一个',
        'ok' => '好的',
        'this_action_is_not_allowed_for_default_record' => '默认记录不允许此操作。',
        'show' => '展示',
        'something_wen_wrong' => '发生了一些问题',
        'cancelled_successfully' => '成功取消',
        'invalid_username_password' => '用户名或密码无效',
        'logged_in_successfully' => '成功登录',
        'logout_successfully' => '成功登出',
        'we_cant_find_user' => '我们无法找到使用此电子邮件地址的用户',
        'we_have_your_password_resetk_link' => '我们已通过电子邮件发送了您的密码重置链接！',
        'this_password_reset_token_is_invalid' => '此密码重置令牌无效',
        'password_reset_successfully' => '密码重置成功',
        'please_enter_correct_old_password' => '请输入正确的旧密码',
        'password_updated' => '密码已更新',
        'doctor_scheduled' => '医生已安排',
        'not_updated' => '未更新',
        'patient_registered_successfully' => '成功注册患者',
        'appointment_confirmed_successfully' => '成功确认预约',
        'bed_assigned_successfully' => '成功分配床位',
        'username_and_password_required' => '需要用户名和密码',
        'meeting_finished_or_cancelled' => '此会议已结束或已取消',
        'alreay_exists' => '已經存在了。',
        'appointment_transaction' => '预约交易'
    ],

    'hospital_schedules' => [
        'schedule_not_available' => '当前用户无法创建医院排班，因为医院排班不可用。',
        'this_day_hospital_is_closed' => '当天医院关闭。',
        'exists_doctor_schedule' => '一些医生将他们的日子安排在给定的未经检查的日子里，所以您确定要执行此操作吗？',
    ],

    'months' => [
        'jan' => '一月',
        'feb' => '二月',
        'mar' => '行进',
        'apr' => '四月',
        'may' => '可能',
        'jun' => '六月',
        'july' => '七月',
        'aug' => '八月',
        'sep' => '九月',
        'oct' => '十月',
        'nov' => '十一月',
        'dec' => '十二月',
    ],

    'weekdays' => [
        'sun' => '太阳',
        'mon' => '星期一',
        'tue' => '周二',
        'wed' => '星期三',
        'thu' => '周四',
        'fri' => '周五',
        'sat' => '坐',
    ],

    // receptionist keys
    'receptionist' => [
        'receptionist' => '接待员',
        'receptionists' => '接待员',
        'receptionist_details' => '接待员详细信息',
        'new_receptionist' => '新接待员',
        'edit_receptionist' => '编辑接待员',
        'profile_must_be_image' => '個人資料圖片必須是圖片',
    ],

    // insurance keys
    'insurance' => [
        'insurance' => '保险',
        'insurances' => '保险',
        'insurance_details' => '保险明细',
        'new_insurance' => '新保险',
        'edit_insurance' => '编辑保险',
        'service_tax' => '服务税',
        'insurance_no' => '保险业',
        'insurance_code' => '保险守则',
        'hospital_rate' => '住院率',
        'discount' => '折扣',
        'remark' => '备注',
        'disease_details' => '疾病详情',
        'diseases_name' => '疾病名称',
        'diseases_charge' => '疾病费',
        'total_amount' => '总金额',
    ],

    //doctor department
    'doctor_department' => [
        'doctor_departments' => '医生科室',
        'doctor_department' => '医生科',
        'doctor_department_details' => '医生科详细资料',
        'new_doctor_department' => '新医生科',
        'edit_doctor_department' => '编辑医生部门',
        'title' => '标题',
        'description' => '描述',
        'doctor_field_required' => '醫生欄位為必填項'
    ],

    // investigation reports
    'investigation_report' => [
        'investigation_reports' => '调查报告',
        'investigation_report' => '调查报告',
        'new_investigation_report' => '新调查报告',
        'investigation_report_details' => '调查报告明细',
        'edit_investigation_report' => '编辑调查报告',
        'patient' => '患者',
        'date' => '日期',
        'title' => '标题',
        'doctor' => '医生',
        'description' => '描述',
        'attachment' => '附件',
        'birth_date_validation' => '调查报告日期不应小于患者出生日期。',
    ],

    // pharmacist keys
    'pharmacist' => [
        'new_pharmacist' => '新药师',
        'edit_pharmacist' => '编辑药剂师',
        'pharmacists' => '药剂师',
        'pharmacist_details' => '药剂师详细信息',
    ],

    // death reports keys
    'death_report' => [
        'death_report' => '死亡报告',
        'death_reports' => '死亡报告',
        'new_death_report' => '新死亡报告',
        'edit_death_report' => '编辑死亡报告',
        'death_report_details' => '死亡报告详细信息',
        'patient_name' => '患者姓名',
        'case_id' => '案例ID',
        'doctor_name' => '医生姓名',
        'date' => '日期',
        'description' => '描述',
        'cant_create_report_because_the_patient_has_been_dead' => '无法创建报告，因为患者已经去世。',
        'data_should_not_be_smaller_than_patient_birth_date' => '日期不应早于患者出生日期。',
    ],

    // birth reports keys
    'birth_report' => [
        'birth_report' => '出生报告',
        'birth_reports' => '出生报告',
        'birth_report_details' => '出生报告详细信息',
        'new_birth_report' => '新出生报告',
        'edit_birth_report' => '编辑出生报告',
        'patient_name' => '患者姓名',
        'case_id' => '案例ID',
        'doctor_name' => '医生姓名',
        'date' => '日期',
        'description' => '描述',
        'data_should_not_be_smaller_than_patient_birth_date' => '日期不应小于患者出生日期.',
        'patient_birth_date_not_found' => '未找到患者出生日期.',
    ],

    // accountant keys
    'accountant' => [
        'new_accountant' => '新会计',
        'edit_accountant' => '编辑会计师',
        'accountants' => '会计师',
        'accountant_details' => '会计师详细信息',
    ],

    // employee payroll keys
    'employee_payroll' => [
        'employee_payroll' => '员工工资单',
        'employee_payrolls' => '员工工资单',
        'employee_payroll_details' => '员工工资明细',
        'new_employee_payroll' => '新员工工资单',
        'edit_employee_payroll' => '编辑员工工资单',
        'sr_no' => '高级',
        'payroll_id' => '工资单编号',
        'month' => '月',
        'year' => '年',
        'role' => '角色',
        'employee' => '雇员',
        'basic_salary' => '基础工资',
        'allowance' => '津贴',
        'deductions' => '扣除额',
        'net_salary' => '净工资',
        'paid' => '已付费',
        'not_paid' => '未付',
        'employee_name' => '员工姓名',
        'employees_list_not_found' => '员工列表未找到',
        'employee_payroll_deduction' => '扣款不应大于基本工资 + 津贴',
    ],

    // operation reports keys
    'operation_report' => [
        'operation_report' => '营运报告',
        'operation_reports' => '营运报告',
        'operation_report_details' => '运营报告明细',
        'new_operation_report' => '新运作报告',
        'edit_operation_report' => '编辑操作报告',
        'patient_name' => '患者姓名',
        'case_id' => '案例ID',
        'doctor_name' => '医生姓名',
        'date' => '日期',
        'description' => '描述',
        'data_should_not_be_smaller_than_patient_birth_date' => '日期不应早于患者出生日期',
    ],

    // accounts keys
    'account' => [
        'account' => '帐户',
        'accounts' => '帐目',
        'account_details' => '帐户详细资料',
        'new_account' => '新账户',
        'edit_account' => '编辑帐户',
        'name' => '名称',
        'description' => '描述',
        'type' => '类型',
        'status' => '状态',
        'payments' => '付款方式',
        'credit' => '信用',
        'debit' => '借方',
    ],

    // invoices keys
    'invoice' => [
        'invoice_id' => '发票编号',
        'invoice' => '发票',
        'invoices' => '发票',
        'invoice_details' => '发票明细',
        'new_invoice' => '新发票',
        'edit_invoice' => '编辑发票',
        'patient' => '患者',
        'invoice_date' => '发票日期',
        'amount' => '量',
        'patient_id' => '患者编号',
        'discount' => '折扣',
        'account_name' => '用户名',
        'description' => '描述',
        'qty' => '数量',
        'price' => '价钱',
        'add' => '加',
        'sub_total' => '小计',
        'total' => '总金额',
        'edit' => '编辑',
        'hospital_address' => '医院地址',
        'paid' => '已付费',
        'not_paid' => '没有支付',
        'print_invoice' => '列印发票',
        'invoice_date_field_required' => '發票日期欄位為必填項',
        'issue_for' => '問題針對',
        'issue_from' => '發出自',
        'patient_overview' => '患者概覽',
        'in_percentage' => '以百分比表示',
    ],

    //nurses
    'nurse' => [
        'nurse' => '护士',
        'new_nurse' => '新护士',
        'edit_nurse' => 'Edit Nurse',
        'nurse_details' => '护士详细信息',
        'phone_no' => '电话号码',
        'birth_date' => '生日',
        'choose' => '选择',
    ],

    //patient
    'patient' => [
        'new_patient' => '新病人',
        'edit_patient' => '编辑病人',
        'patient_details' => '患者详细资料',
        'total_cases' => '总病例',
        'total_admissions' => '总招生',
        'total_appointments' => '总约会',
        'select_one_patient' => '請至少選擇一名患者',
        'patient_name_already_taken' => '病患姓名已被佔用',
        'patient_field_required' => '患者欄位為必填項',
    ],

    // payments keys
    'payment' => [
        'payment' => '付款',
        'payments' => '付款方式',
        'payment_details' => '付款详情',
        'new_payment' => '新付款',
        'edit_payment' => '编辑付款',
        'account_name' => '用户名',
        'payment_date' => '支付日期',
        'pay_to' => '付给',
        'amount' => '量',
        'account' => '帐户',
        'description' => '描述',
        'payment_reports' => '付款报告',
        'your_payment_is_successfully_completed' => '您的支付已成功完成',
        'payment_failed' => '抱歉！支付失败，请稍后再试',
        'flutterwave_not_support' => 'Flutterwave 不支持该货币。',
        'phonepe_support_inr' => 'PhonePe 仅支持 INR 货币。',
        'paystack_support_zar' => 'Paystack 仅支持 "USD","GHS","NGN","ZAR","KES" 货币。',
        'paystack_token_expired' => 'Paystack 令牌已过期。请刷新页面并重试。',
        'currency_not_supported_paypal' => 'PayPal 不支持此货币付款。',
    ],

    // advanced payments keys
    'advanced_payment' => [
        'advanced_payment' => '预付款',
        'advanced_payments' => '预付款',
        'advanced_payment_details' => '预付款明细',
        'new_advanced_payment' => '新预付款',
        'edit_advanced_payment' => '编辑预付款',
        'patient' => '患者',
        'receipt_no' => '收据编号',
        'amount' => '量',
        'date' => '日期',
        'patient_name' => '患者姓名',
    ],

    // beds keys
    'bed' => [
        'bed' => '新床',
        'beds' => '床铺',
        'bed_details' => '床详情',
        'new_bed' => '新床',
        'edit_bed' => '编辑床',
        'new_bulk_bed' => '新大床',
        'name' => '名称',
        'bed_type' => '床型',
        'charge' => '收费',
        'available' => '可用的',
        'not_available' => '无法使用',
        'description' => '描述',
        'add' => '加',
        'bed_id' => '床号',
        'select_bed_type' => '選擇床型',
        'bed_charge' => '床位費',
    ],

    // bed types keys
    'bed_type' => [
        'bed_type' => '床型',
        'bed_types' => '床型',
        'bed_type_details' => '床型详情',
        'new_bed_type' => '新床型',
        'edit_bed_type' => '编辑床型',
        'title' => '标题',
        'description' => '描述',
    ],

    'doctor' => [
        'new_doctor' => '新医生',
        'edit_doctor' => '编辑医生',
        'doctor_details' => '医生详细资料',
        'specialist' => '专家',
        'name' => '名称',
        'doctor_name_already_taken' => '醫生的名字已被佔用',
        'appointment_charge' => '预约费用',
    ],

    // bed assigns keys
    'bed_assign' => [
        'bed_assign' => '床分配',
        'bed_assigns' => '床分配',
        'bed_assign_details' => '床分配详细信息',
        'new_bed_assign' => '新床分配',
        'edit_bed_assign' => '编辑床分配',
        'patient_name' => '患者姓名',
        'bed_name' => '床名',
        'case_id' => '案例ID',
        'assign_date' => '分配日期',
        'discharge_date' => '出院日期',
        'bed' => '床',
        'description' => '描述',
        'assigned' => '已分配',
        'not_assigned' => '未分配',
        'ipd_patient_id' => 'IPD患者编号',
        'assign_date_should_not_be_smaller_than_patient_birth_date' => '分配日期不应小于患者出生日期。',
        'ipd_patient_department_field_required' => 'IPD 病患科室欄位為必填項',
    ],

    // packages keys
    'package' => [
        'package' => '包',
        'packages' => '配套',
        'package_details' => '包装详情',
        'new_package' => '新包装',
        'edit_package' => '编辑包',
        'name' => '名称',
        'description' => '描述',
        'discount' => '折扣',
        'total_amount' => '总金额',
        'service' => '服务',
        'qty' => '数量',
        'rate' => '率',
        'amount' => '量',
        'select_service' => '选择服务',
    ],

    // bills keys
    'bill' => [
        'print_bill' => '列印帐单',
        'bill_id' => '帐单编号',
        'bill' => '法案',
        'bills' => '账单',
        'bill_details' => '账单明细',
        'new_bill' => '新法案',
        'edit_bill' => '编辑帐单',
        'patient' => '患者',
        'bill_date' => '帐单日期',
        'amount' => '量',
        'admission_id' => '入场证',
        'patient_name' => '患者姓名',
        'patient_email' => '患者电子邮件',
        'patient_cell_no' => '患者细胞编号',
        'patient_gender' => '病人性别',
        'patient_dob' => '患者DOB',
        'doctor_name' => '医生姓名',
        'admission_date' => '入学日期',
        'discharge_date' => '出院日期',
        'package_name' => '包裹名字',
        'insurance_name' => '保险名称',
        'total_days' => '总天数',
        'policy_no' => '保单编号',
        'item_name' => '项目名称',
        'qty' => '数量',
        'price' => '价钱',
        'add' => '加',
        'total_amount' => '总金额',
        'edit' => '编辑',
        'cell_no' => '单元号',
        'bill_summary' => '账单摘要',
        'generate_bill' => '生成账单',
        'update_bill' => '更新账单',
        'calculate' => '计算',
        'manual_bill' => '手動計費付款',
        'transaction_date' => '交易日期',
        'paymentrequest_sent' => '付款請求發送成功',
        'manually' => '手動',
        'stripe' => '條紋',
        'approved' => '得到正式認可的',
        'rejected' => '拒絕',
        'are_you_sure' => '你確定嗎？',
        'complete_this_payment' => '您想手動完成此付款！',
        'session_id_required' => '需要會話 ID',
    ],

    // blood donors keys
    'blood_donor' => [
        'blood_donor' => '献血者',
        'blood_donors' => '献血者',
        'blood_donor_details' => '献血者详细资料',
        'new_blood_donor' => '新献血者',
        'edit_blood_donor' => '编辑献血者',
        'name' => '名称',
        'age' => '年龄',
        'gender' => '性别',
        'blood_group' => '血型',
        'donation_date' => '捐赠日期',
        'last_donation_date' => '最后捐赠日期',
    ],

    // blood banks keys
    'hospital_blood_bank' => [
        'blood_bank' => '血库',
        'blood_banks' => '血库',
        'blood_bank_details' => '血库详细信息',
        'new_blood_group' => '新血型',
        'edit_blood_group' => '编辑血型',
        'blood_group' => '血型',
        'remained_bags' => '剩余行李',
    ],

    //Case
    'case' => [
        'case' => '案件',
        'case_date' => '案件日期',
        'new_case' => '新案例',
        'edit_case' => '编辑案例',
        'case_details' => '案件详情',
        'phone' => '电话',
        'fee' => '费用',
        'patient' => '患者',
        'doctor' => '医生',
        'case_id' => '案例ID',
        'date' => '日期',
        'description' => '说明z',
        'case_date_should_not_be_smaller_than_patient_birth_date' => '病例日期不应早于患者出生日期',
    ],

    //services
    'service' => [
        'service' => '服务',
        'new_service' => '新服务',
        'edit_service' => '编辑服务',
        'service_details' => '服务详情',
        'quantity' => '数量',
        'rate' => '率',
        'given' => '给定',
        'not_given' => '没有给',
    ],

    //appointments
    'appointment' => [
        'new_appointment' => '新任命',
        'edit_appointment' => '编辑约会',
        'appointment_details' => '预约详情',
        'calendar_view' => '日历视图',
        'patient_name' => '患者姓名',
        'doctor_name' => '医生姓名',
        'department_name' => '部门名称',
        'date' => '日期',
        'doctor_department' => '医生科',
        'doctor_department_name' => '医生科名称',
        'doctor' => '医生',
        'description' => '描述',
        'patient' => '患者',
        'appointment_calendar' => '预约日历',
        'appointment_list' => '预约表',
        'completed' => '已完成',
        'pending' => '待定',
        'available_slot' => '可用插槽',
        'no_available' => '无法使用',
        'today' => '今天',
        'month' => '月',
        'week' => '星期',
        'day' => '日',
        'opd_date' => '日期',
        'yesterday' => '昨天',
        'this_week' => '本星期',
        'last_7_days' => '过去 7 天',
        'last_30_days' => '过去 30 天',
        'this_month' => '这个月',
        'last_month' => '上个月',
        'change_status' => '更改状态',
        'are_you_sure_want_to_change' => '您确定要更改吗',
        'changed_appointment' => '更改约会',
        'has_been_changed' => '已经变了。',
        'please_select_doctor_department' => '请选择医生科室',
        'please_select_doctor' => '请选择医生',
        'doctor_schedule_not_available_on_this_date' => '医生时间表此日期不可用。',
        'please_select_appointment_time_slot' => '请选择预约时间段',
        'patient_not_exists_or_status_is_not_active' => '患者不存在或状态未激活。',
        'appointment_exists' => '患者电子邮件已存在',
        'old_patient_email_exists' => '邮箱已经存在，请选择老病人。',
        'time' => '时间',
    ],

    'case_handler' => [
        'case_handler' => '办案员',
        'new_case_handler' => '新案处理人',
        'edit_case_handler' => '编辑案例处理程序',
        'case_handler_detail' => '案件处理人员详细信息',
    ],

    'lab_tech' => [
        'lab_technician' => '实验室技术员',
        'new_lab_tech' => '新实验室技术员',
        'edit_lab_tech' => '编辑实验室技术员',
        'lab_tech_detail' => '实验室技术员详细信息',
    ],

    'doc_type' => [
        'new_doc_type' => '新文件类型',
        'edit_doc_type' => '编辑文件类型',
        'name' => '名称',
    ],

    'document' => [
        'document' => '文献',
        'documents' => '文件资料',
        'new_document' => '新文件',
        'edit_document' => '编辑文件',
        'title' => '标题',
        'document_type' => '文件类型',
        'document_type_details' => '文件类型详细资料',
        'patient' => '患者',
        'download' => '下载',
        'select_patient' => '选择患者',
        'select_document_type' => '选择文件类型',
        'uploaded_by' => '上传者',
        'document_detail' => '文件详细资料',
        'notes' => '笔记',
        'attachment' => '附件',
        'validate_doc_type' => '文件必须是以下类型之一：jpeg、jpg、png、pdf、doc、docx、webp',
        'select_attachment' => '請選擇附件。',
    ],

    'patient_admission' => [
        'patient_admission' => '病人入院',
        'new_patient_admission' => '新病人入院',
        'edit_patient_admission' => '编辑患者入场',
        'details' => '病人入院详情',
        'patient' => '患者',
        'patient_name' => '患者姓名',
        'doctor' => '医生',
        'doctor_name' => '医生姓名',
        'admission_date' => '入学日期',
        'discharge_date' => '出院日期',
        'package' => '包',
        'package_name' => '包裹名字',
        'insurance' => '保险',
        'insurance_name' => '保险名称',
        'policy_no' => '保单编号',
        'bed' => '床',
        'agent_name' => '代理名称',
        'guardian_name' => '监护人姓名',
        'guardian_relation' => '监护人关系',
        'guardian_contact' => '监护人联系',
        'guardian_address' => '监护人地址',
        'patient_admission_id' => '病人入场证',
        'admission_date_should_not_be_smaller_than_patient_birth_date' => '入院日期不应早于患者出生日期',
        'Admission_field_required' => '入場 ID 欄位為必填欄位。'
    ],

    'setting' => [
        'app_name' => '应用程序名称',
        'company_name' => '公司名称',
        'app_logo' => '应用程序标志',
        'currency' => '当前货币',
        'address' => '医院地址',
        'hospital_email' => '医院电子邮件',
        'hospital_phone' => '医院电话',
        'hospital_from_day' => '医院从日期开始',
        'hospital_from_time' => '医院从时间开始',
        'about_us' => '关于我们',
        'image_validation' => '图像必须为90 x 60像素。',
        'favicon' => '网站图标 (Favicon)',
        'favicon_validation' => '图像必须为34 x 34像素。',
        'social_details' => '社交详细信息',
        'country_code' => '国家代码',
        'default_language' => '默认语言',
    ],

    'currency' => [
        'currency' => '货币',
        'new_currency' => '新货币',
        'edit_currency' => '编辑货币',
        'currency_name' => '货币名称',
        'currency_code' => '货币代码',
        'currency_icon' => '货币图标',
        'add_currency_code_as_per_three_letter_iso_code' => '按照三字母 ISO 代码添加货币代码',
        'you_can_find_out_here' => '你可以在这里找到',
        'currency_setting_not_found' => '未找到货币设置',
    ],

    'schedule' => [
        'new' => '新时间表',
        'edit' => '编辑时间表',
        'details' => '时间表详情',
        'doctor_name' => '医生姓名',
        'select_doctor_name' => '选择医生姓名',
        'per_patient_time' => '每位患者时间',
        'serial_visibility' => '串行可见性',
        'select_serial_visibility' => '选择串行可见性',
        'available_on' => '可用',
        'available_from' => '可从',
        'available_to' => '有空',
        'sequential' => '顺序的',
        'timestamp' => '时间戳记',
        'schedule_time_select' => '请为每位患者选择时间',
        'schedule_time' => '可用时间必须大于医院的排班时间',
        'available_time_greater_than_zero' => '可用时间必须大于零',
        'available_to_time_greater_than_zero' => '可用结束时间必须大于零',
        'available_time_less_than_hospital_schedule_time' => '可用结束时间必须小于医院的排班时间',
    ],

    'notice_board' => [
        'notice_board' => '公告栏',
        'new' => '新公告板',
        'edit' => '编辑公告栏',
        'details' => '公告栏详细信息',
        'title' => '标题',
        'description' => '描述',
        'created_at' => '創建於',
    ],

    'my_payroll' => [
        'my_payrolls' => '我的工资单',
        'basic_salary' => '基础工资',
        'allowance' => '津贴',
        'deductions' => '扣除额',
        'net_salary' => '净工资',
    ],

    'medicine' => [
        'medicine' => '医学',
        'medicine_category' => '药物类别',
        'medicine_category_details' => '药物类别详细信息',
        'medicines' => '药品',
        'medicine_details' => '药物细节',
        'new_medicine' => '新药',
        'new_medicine_category' => '新药分类',
        'edit_medicine_category' => '编辑药物类别',
        'edit_medicine' => '编辑医学',
        'name' => '名称',
        'brand' => '牌',
        'selling_price' => '售价',
        'buying_price' => '买价',
        'category' => '类别',
        'salt_composition' => '盐成分',
        'side_effects' => '副作用',
        'description' => '描述',
        'category_id' => '类别编号',
        'brand_name' => '品牌',
        'medicine_brands' => '医药品牌',
        'medicine_brands_details' => '药品品牌详细信息',
        'new_brand' => '新品牌',
        'new_medicine_brand' => '新药品牌',
        'edit_medicine_brand' => '编辑医药品牌',
        'select_category' => '选择类别',
        'select_brand' => '选择品牌',
        'is_active' => '是否激活',
        'delete_medicine' => '此药品已在药费中使用，确定要删除吗？',
        'category_field_required' => '類別欄位為必填項',
        'brand_field_required' => '品牌欄位為必填項。',
    ],

    'profile' => [
        'change_language' => '改变语言',
        'language' => '语言',
        'edit_profile' => '编辑个人资料',
        'first_name' => '名',
        'last_name' => '姓',
        'email' => '电子邮件',
        'phone' => '电话',
        'profile' => '轮廓',
    ],

    'dashboard' => [
        'dashboard' => '仪表板',
        'total_invoices' => '发票总额',
        'total_bills' => '账单总额',
        'total_payments' => '总付款额',
        'total_advance_payments' => '预付款总额',
        'notice_boards' => '公告栏',
        'title' => '标题',
        'doctors' => '醫生',
        'available_beds' => '可用床',
        'patients' => '耐心',
        'income_and_expense_report' => '收支报告',
        'income_and_expense_reports' => '收支报告',
        'no_enquiries_yet' => '还没有查询',
        'no_notice_yet' => '还没有通知',
        'total_appointment' => '总预约数',
        'today_appointment' => '今日预约',
        'total_meeting' => '会议总数',
        'sum_of_ipd' => 'IPD 应付金额',
        'recent_appointments' => '最近的约会',
    ],

    // enquiries keys
    'enquiry' => [
        'name' => '名称',
        'email' => '电子邮件',
        'contact' => '联系',
        'type' => '类型',
        'message' => '信息',
        'viewed_by' => '查看者',
        'enquiry_details' => '查询详情',
        'read' => '读',
        'unread' => '未读',
        'not_viewed' => '未查看',
        'received_on' => '收到日期',
        'send_enquiry' => '发送查询',
        'enquiry_send_successfully' => '询盘发送成功',
    ],

    'email' => [
        'to' => '至',
        'subject' => '学科',
        'message' => '信息',
        'attachment' => '附件',
    ],

    'verification' => [
        'verify_your_email_address' => '确认你的邮件地址',
        'verify_message' => '在继续之前，请检查您的电子邮件以获取验证链接。如果您没有收到电子邮件，',
        'another_verify_request' => '单击此处请求另一个',
        'click_button_for_verify_email' => '請點擊下面的按鈕來驗證您的電子郵件地址。',
        'further_action_required' => '如果您沒有建立帳戶，則無需採取進一步操作。',
        'verify_email_address' => '确认电子邮件地址',
    ],

    // ambulances keys
    'ambulance' => [
        'ambulance' => '救护车',
        'ambulances' => '救护车',
        'ambulance_details' => '救护车详细信息',
        'vehicle_number' => '车号',
        'vehicle_model' => '车辆型号',
        'year_made' => '年份',
        'driver_name' => '驱动程式名称',
        'driver_license' => '驾驶执照',
        'driver_contact' => '驾驶员联系',
        'note' => '注意',
        'vehicle_type' => '车辆类型',
        'is_available' => '有空',
        'new_ambulance' => '新救护车',
        'edit_ambulance' => '编辑救护车',
    ],

    // ambulance calls keys
    'ambulance_call' => [
        'ambulance_call' => '救护车呼叫',
        'ambulance_calls' => '救护车电话',
        'ambulance_call_details' => '救护车通话详情',
        'vehicle_model' => '车辆型号',
        'patient' => '患者',
        'driver_name' => '驱动程式名称',
        'date' => '日期',
        'amount' => '量',
        'new_ambulance_call' => '新的救护车呼叫',
        'edit_ambulance_call' => '编辑救护车通话',
    ],

    // prescription keys
    'prescription' => [
        'reference_id' => '參考編號',
        'prescription' => '处方',
        'prescriptions' => '处方药',
        'prescription_details' => '处方详情',
        'new_prescription' => '新处方',
        'edit_prescription' => '编辑处方',
        'patient' => '患者',
        'food_allergies' => '食物过敏',
        'tendency_bleed' => '倾向流血',
        'heart_disease' => '心脏病',
        'high_blood_pressure' => '高血压',
        'diabetic' => '糖尿病的',
        'surgery' => '手术',
        'accident' => '事故',
        'others' => '其他',
        'medical_history' => '添加于',
        'current_medication' => '当前药物',
        'female_pregnancy' => '女性怀孕',
        'breast_feeding' => '母乳喂养',
        'health_insurance' => '健康保险',
        'low_income' => '低收入',
        'reference' => '参考',
        'physical_information' => '物理信息',
        'new_medicine' => '新药',
        'plus_rate' => '心率',
        'temperature' => '温度',
        'problem_description' => '问题描述',
        'test' => '测试',
        'advice' => '建议',
        'next_visit' => '下次访问',
        'time' => '时间',
        'comment' => '评论',
        'problem' => '问题',
        'Rx' => '接收',
        'medicine_name' => '药名',
        'duration' => '期间',
        'days' => '天',
        'after_meal' => '吃饭后',
        'before_meal' => '饭前',
        'year' => '年',
        'month' => '月',
        'no_data_available' => '没有找到数据',
    ],

    'charge_category' => [
        'charge_categories' => '收费类别',
        'new_charge_category' => '新收费类别',
        'edit_charge_category' => '编辑费用类别',
        'charge_type' => '收费类型',
        'charge_category_details' => '收费类别详细信息',
    ],

    'charge' => [
        'new_charge' => '新收费',
        'edit_charge' => '编辑费用',
        'charge_details' => '收费明细',
        'charge_category' => '收费类别',
        'standard_charge' => '标准收费',
        'code' => '码',
    ],

    // radiology keys
    'radiology_category' => [
        'name' => '名称',
        'radiology_categories' => '放射学 分类目录',
        'new_radiology_category' => '新 放射学 类别',
        'edit_radiology_category' => '编辑 放射学 类别',
    ],
    // pathology keys
    'pathology_category' => [
        'pathology_categories' => '病理 分类目录',
        'new_pathology_category' => '新 病理 类别',
        'edit_pathology_category' => '编辑 病理 类别',
        'name' => '名称',
        'select_charge_category' => '选择收费类别',
    ],

    // radiology test keys
    'radiology_test' => [
        'radiology_tests' => '放射学检查',
        'new_radiology_test' => '新放射学测试',
        'edit_radiology_test' => '编辑放射学测试',
        'radiology_test_details' => '放射学检查详细信息',
        'test_name' => '测试名称',
        'short_name' => '简称',
        'test_type' => '测试类型',
        'category_name' => '分类名称',
        'subcategory' => '子类别',
        'report_days' => '报告天数',
        'charge_category' => '收费类别',
        'code' => '代码',
        'standard_charge' => '标准收费',
    ],

    //doctor opd charge keys
    'doctor_opd_charge' => [
        'doctor_opd_charge' => '医生 OPD 费用',
        'new_doctor_opd_charge' => '新医生OPD费用',
        'edit_doctor_opd_charge' => '编辑医生OPD费用',
        'doctor_name' => '医生姓名',
        'standard_charge' => '标准收费',
        'doctor' => '医生',
    ],
    // pathology test keys
    'pathology_test' => [
        'pathology_tests' => '病理检查',
        'new_pathology_test' => '新病理学检查',
        'edit_pathology_test' => '编辑病理测试',
        'pathology_test_details' => '病理学检查细节',
        'test_name' => '测试名称',
        'short_name' => '简称',
        'test_type' => '测试类型',
        'category_name' => '分类名称',
        'unit' => '单元',
        'subcategory' => '子类别',
        'method' => '方法',
        'report_days' => '报告天数',
        'charge_category' => '收费类别',
        'standard_charge' => '标准收费',
    ],

    //expenses keys
    'expense' => [
        'expense' => '费用',
        'new_expense' => '新费用',
        'edit_expense' => '编辑费用',
        'expense_head' => '费用头',
        'name' => '名称',
        'date' => '日期',
        'invoice_number' => '发票编号',
        'amount' => '量',
        'attachment' => '附件',
        'description' => '描述',
        'choose' => '选择',
        'download' => '下载',
        'expense_details' => '费用明细',
        'select_expense_head' => '选择费用头',
        'document_error' => '该文档必须是类型的文件: jpeg, jpg, png, pdf, doc, docx.',
    ],

    //income keys
    'incomes' => [
        'incomes' => '收入状况',
        'new_income' => '新收入',
        'edit_income' => '编辑收入',
        'income_head' => '收入头',
        'name' => '名称',
        'date' => '日期',
        'invoice_number' => '发票编号',
        'amount' => '量',
        'attachment' => '附件',
        'description' => '描述',
        'choose' => '选择',
        'download' => '下载',
        'income_details' => '收入明细',
        'select_income_head' => '选择收入头',
        'document_error' => '该文档必须是类型的文件: jpeg, jpg, png, pdf, doc, docx.',
    ],

    'bed_status' => [
        'bed_status' => 'Bed Status',
        'assigned_beds' => 'Assigned Beds',
        'available_beds' => '可用床',
        'bed_name' => 'Bed Name',
        'patient_name' => '患者姓名',
        'phone' => '电话',
        'admission_date' => '入学日期',
        'gender' => '性别',
    ],

    //Messages keys
    'message' => [
        'message' => '信息',
        'messages' => '留言内容',
        'send_to' => '发送至',
        'subject' => '学科',
        'new_message' => '新消息',
        'messages_details' => '讯息详情',
        'sender_name' => '发件者姓名',
        'date' => '日期',
        'select_user' => '选择用户',
    ],

    //SMS keys
    'sms' => [
        'sms' => '短信',
        'new_sms' => '新短信',
        'send_to' => '发送至',
        'phone_number' => '电话号码',
        'send_by' => '发送者',
        'message' => '信息',
        'sms_details' => '短信详细信息',
        'date' => '日期',
        'send' => '发送',
        'role' => '角色',
        'send_sms_by_number_directly' => '通过号码直接发送短信',
        'only_user_with_registered_phone_will_display' => '（仅显示具有注册电话的用户。）',
        'message_not_greater_than_160_characters' => '消息不能超过160个字符。',
        'set_credential' => '请设置您的凭据。',
    ],

    //Patient Diagnosis Test
    'patient_diagnosis_test' => [
        'diagnosis' => '诊断',
        'diagnosis_test' => '诊断测试',
        'patient_diagnosis_test' => '患者诊断测试',
        'report_number' => '报告编号',
        'patient' => '患者',
        'doctor' => '医生',
        'created_at' => '创建于',
        'action' => '行动',
        'new_patient_diagnosis_test' => '新病人诊断测试',
        'edit_patient_diagnosis_test' => '编辑患者诊断测验',
        'create_patient_diagnosis_test' => '创建患者诊断测试',
        'patient_diagnosis_test_details' => '患者诊断测试详细信息',
        'diagnosis_category' => '诊断类别',
        'add_other_diagnosis_property' => '添加其他诊断属性',
        'other_diagnosis_property' => '其他诊断属性',
        'diagnosis_property_name' => '诊断属性名称',
        'diagnosis_property_value' => '诊断属性值',
        'patient_name' => '患者姓名',
        'doctor_name' => '医生姓名',
        'age' => '年龄',
        'height' => '高度',
        'weight' => '重量',
        'average_glucose' => '平均血糖',
        'fasting_blood_sugar' => '空腹血糖',
        'urine_sugar' => '尿糖',
        'blood_pressure' => '血压',
        'diabetes' => '糖尿病',
        'cholesterol' => '胆固醇',
        'print_diagnosis_test' => '打印诊断测试',
    ],

    //Diagnosis Category
    'diagnosis_category' => [
        'diagnosis_category' => '诊断类别',
        'diagnosis_categories' => '诊断类别',
        'new_diagnosis_category' => '新诊断类别',
        'description' => '描述',
        'category_name' => '分类名称',
        'diagnosis_category_details' => '诊断类别详细信息',
        'edit_diagnosis_category' => '编辑诊断类别',
    ],

    // Operation Category
    'operation_category' => [
        'operation_category' => '操作类别',
        'operation_categories' => '操作类别',
        'new_operation_category' => '新的操作类别',
        'edit_operation_category' => '编辑操作类别',
        'operation_category_field_required' => '操作類別欄位是必需的。',
    ],

    // Operation
    'operation' => [
        'operation' => '手术',
        'operation_field_required' => '操作欄位為必填項。',
        'select_operation_date' => '請選擇手術日期。',
        'operation_date' => '營業日期',
        'operation_name' => '操作名稱',
        'operation_category_name' => '操作類別 名稱',
        'ot_technician' => 'OT技術員',
        'ot_assistant' => '手術助理',
    ],

    // Inventory Management keys
    'item_category' => [
        'item_category' => '项目类别',
        'item_categories' => '项目类别',
        'new_item_category' => '新商品类别',
        'edit_item_category' => '编辑项目类别',
        'name' => '名称',
    ],

    'item' => [
        'item' => '项目',
        'items' => '物品',
        'new_item' => '新物品',
        'edit_item' => '编辑项目',
        'item_details' => '项目明细',
        'name' => '名称',
        'item_category' => '项目类别',
        'unit' => '单元',
        'description' => '描述',
        'available_quantity' => '可用数量',
    ],

    'item_stock' => [
        'item_stock' => '物品库存',
        'item_stocks' => '物品库存',
        'new_item_stock' => '新商品库存',
        'edit_item_stock' => '编辑物品库存',
        'item_stock_details' => '项目库存明细',
        'item_category' => '项目类别',
        'item' => '项目',
        'supplier_name' => '供应商名称',
        'store_name' => '店铺名称',
        'quantity' => '数量',
        'purchase_price' => '购买价格',
        'description' => '描述',
        'attachment' => '附件',
    ],

    'issued_item' => [
        'issued_item' => '发行物品',
        'issued_items' => '发行物品',
        'new_issued_item' => '新发行物品',
        'edit_issued_item' => '编辑签发项目',
        'issued_item_details' => '发货项目明细',
        'department_id' => '用户类型',
        'user_id' => '发给',
        'issued_by' => '发行人',
        'issued_date' => '发行日期',
        'return_date' => '归期',
        'item_category' => '项目类别',
        'item' => '项目',
        'quantity' => '数量',
        'description' => '描述',
        'available_quantity' => '可用数量',
        'item_return' => '归还物品',
        'item_returned' => '回来',
        'are_you_sure_want_to_return_this_item' => '您确定要退回此商品吗',
        'quantity_cannot_be_zero' => '数量不能为零。',
        'quantity_must_be_less_than_available_quantity' => '数量必须小于可用数量。',
    ],

    'ipd_patient' => [
        'ipd_patient_in' => 'IPD-- 病人在',
        'ipd_patient' => 'IPD患者',
        'ipd_patients' => 'IPD患者',
        'new_ipd_patient' => '新IPD患者',
        'edit_ipd_patient' => '编辑IPD患者',
        'ipd_patient_details' => 'IPD患者详细信息',
        'patient_id' => '患者',
        'ipd_number' => 'IPD号码',
        'height' => '高度',
        'weight' => '重量',
        'bp' => '血压',
        'symptoms' => '症状',
        'notes' => '注释',
        'admission_date' => '入学日期',
        'case_id' => '案件',
        'is_old_patient' => '是老年患者',
        'doctor_id' => '医生',
        'bed_type_id' => '床型',
        'bed_id' => '床',
        'bill_status' => '账单状态',
        'the_case_field_is_required' => '案例字段是必需的。',
        'the_bed_field_is_required' => '床字段是必需的。',
        'the_bed_field_has_a_duplicate_value' => 'bed 欄位有重複值',
        'the_bed_already_taken' => '床：輸入已被採取',
        'the_bed_type_is_required' => '床型字段为必填项。',
        'charge_required' => '收费字段 必填。',
        'discharge' => '释放',
        'net_amount' => '净额',
        'discharged' => '出院',
        'not_dischared' => '未出院',
        'discharge_slip' => '卸料單',
        'print_discharge_slip' => '列印放電單',
    ],

    'ipd_patient_diagnosis' => [
        'new_ipd_diagnosis' => '添加诊断',
        'edit_ipd_diagnosis' => '编辑诊断',
        'report_type' => '报告类型',
        'report_date' => '报告日期',
        'document' => '文件',
        'description' => '描述',
    ],

    'ipd_patient_consultant_register' => [
        'applied_date_or_Instruction_date_can_not_be_null' => '申请日期或指示日期不能为空',
        'consultant_instruction' => '顾问指导',
        'consultant_doctor' => '顾问医生',
        'edit_consultant_register' => '編輯顧問說明',
        'new_consultant_register' => '添加顾问指令',
        'applied_date' => '应用日期',
        'doctor_id' => '医生',
        'instruction' => '指令',
        'instruction_date' => '指令日期',
        'applied_date_or_Instruction_date_can_not_be_null' => '申請日期或指示日期不能為空',
        'assistant_consultant_1' => '助理顧問1名',
        'assistant_consultant_2' => '助理顧問2名',
        'anesthetist' => '麻醉醫師',
        'anesthesia_type' => '麻醉類型',
        'instruction_field_is_required' => '說明欄位是必需的。',
    ],

    'ipd_patient_charges' => [
        'new_charge' => '添加费用',
        'date' => '日期',
        'edit_charge' => '編輯費用',
        'charge_type_id' => '收费类型',
        'charge_category_id' => '收费类别',
        'charge_id' => '代码',
        'standard_charge' => '标准费用',
        'applied_charge' => '应用收费',
    ],

    'ipd_patient_prescription' => [
        'ipd_no' => 'IPD否',
        'header_note' => '标题说明',
        'footer_note' => '脚注',
        'new_prescription' => '添加处方',
        'edit_prescription' => '编辑处方',
        'prescription_details' => '处方详细信息',
        'category_id' => '医学类别',
        'medicine_id' => '医学',
        'dosage' => '剂量',
        'instruction' => '指令',
        'print_prescription' => '打印处方',
    ],

    'ipd_patient_timeline' => [
        'timeline' => '时间线',
        'new_ipd_timeline' => '添加时间表',
        'edit_ipd_timeline' => '编辑时间轴',
        'title' => '标题',
        'date' => '日期',
        'description' => '描述',
        'document' => '文件',
        'visible_to_person' => '对人可见',
        'no_timeline_found' => '找不到时间线',
    ],

    'ipd_payments' => [
        'add_ipd_payment' => '添加ipd付款',
        'edit_ipd_payment' => '編輯 IPD 付款',
        'payment_mode' => '付款方式',
        'make_payment' => '进行付款',
    ],

    'ipd_bill' => [
        'paid_amount' => '已付金额',
        'total_charges' => '总费用',
        'gross_total' => '总收入',
        'discount_in_percentage' => '百分比折扣',
        'discount_in_number' => '数字折扣',
        'tax_in_percentage' => '百分比税',
        'tax_in_number' => '税号',
        'other_charges' => '其他费用',
        'net_payable_amount' => '净应付金额',
        'discharge_patient' => '出院病人',
    ],

    'opd_patient' => [
        'opd_patient_out' => 'OPD - 病人出院',
        'opd_patient' => 'OPD患者',
        'opd_patients' => 'OPD患者',
        'new_opd_patient' => '新的OPD患者',
        'edit_opd_patient' => '编辑OPD患者',
        'opd_patient_details' => 'OPD患者详细信息',
        'opd_number' => 'OPD号',
        'appointment_date' => '约定日期',
        'visits' => '来访',
        'revisits' => '重访',
        'total_visits' => '总造访',
    ],

    'opd_payments' => [
        'add_opd_payment' => '添加Opd付款',
        'edit_opd_payment' => '编辑Opd付款',
        'payment_mode' => '付款方式',
        'make_payment' => '付款',
    ],

    'call_log' => [
        'call_log' => '通话记录',
        'new' => '新通话记录',
        'edit' => '编辑通话记录',
        'name' => '名称',
        'phone' => '电话',
        'received_on' => '收到日期',
        'follow_up_date' => '跟进日期',
        'note' => '注意',
        'call_type' => '通话类型',
        'incoming' => '传入',
        'outgoing' => '外向',
    ],

    'visitor' => [
        'visitor' => '游客',
        'new' => '新访客',
        'edit' => '编辑访客',
        'name' => '名称',
        'purpose' => '目的',
        'phone' => '电话',
        'id_card' => '身份证',
        'number_of_person' => '人数',
        'date' => '日期',
        'in_time' => '及时',
        'out_time' => '时差',
        'note' => '注意',
    ],

    'postal' => [
        'postal' => '明信片',
        'new_receive' => '新收到',
        'new_dispatch' => '新派遣',
        'dispatch' => '调度',
        'receive' => '接收',
        'edit_receive' => '编辑接收',
        'edit_dispatch' => '编辑派遣',
        'to_title' => '到标题',
        'from_title' => '从标题',
        'reference_no' => '参考编号',
        'date' => '日期',
        'address' => '地址',
        'validate_from_title' => '发件人标题不能为空',
        'validate_to_title' => '收件人标题不能为空',
    ],

    'testimonial' => [
        'testimonial' => '感言',
        'new_testimonial' => '新推荐书',
        'edit_testimonial' => '编辑推荐书',
        'testimonial_detail' => '推荐细节',
        'name' => '名称',
        'description' => '描述',
        'profile_error' => '文档必须是类型为jpeg，jpg，png的文件。',
    ],

    'blood_donation' => [
        'blood_donation' => '献血',
        'new_blood_donation' => '新献血',
        'edit_blood_donation' => '编辑献血',
        'donor_name' => '捐助者名称',
        'bags' => '包袋',
        'last_donate_date' => '最后捐赠日期',
    ],

    'blood_issue' => [
        'blood_issue' => '血液问题',
        'new_blood_issue' => '新血问题',
        'edit_blood_issue' => '编辑血液问题',
        'issue_date' => '发行日期',
        'patient_name' => '患者名称',
        'doctor_name' => '医生姓名',
        'donor_name' => '捐赠人名称',
        'amount' => '量',
        'remarks' => '备注',
    ],

    'ipd_operation' => [
        'ipd_operation' => '住院手术',
        'ipd_operation_created_successfully' => '住院手术创建成功',
    ],

    'notification' => [
        'all_notification_read_successfully' => '所有通知已成功阅读',
        'notification_read_successfully' => '通知已成功阅读',
        'notifications' => '通知事项',
        'mark_all_as_read' => '标记为已读',
        'you_don`t_have_any_new_notification' => '您没有任何新通知',
    ],

    'live_consultation' => [
        'live_consultation' => '实时咨询',
        'new_live_consultation' => '新的实时咨询',
        'consultation_title' => '咨询标题',
        'consultation_date' => '咨询日期',
        'consultation_duration_minutes' => '咨询持续时间（分钟）',
        'client_video' => '客户视频',
        'host_video' => '主持人视频',
        'enable' => '启用',
        'disabled' => '禁用',
        'type' => '类型',
        'type_number' => '类型编号',
        'created_by' => '创建者',
        'created_for' => '创建于',
        'new_live_meeting' => '新的实时会议',
        'staff_list' => '员工列表',
        'edit_live_consultation' => '编辑实时咨询',
        'duration' => '持续时间（分钟）',
        'start_now' => '立即开始',
        'join_now' => '立即加入',
        'edit_live_meeting' => '编辑实时会议',
        'add_credential' => '添加凭据',
        'zoom_api_key' => 'Zoom API密钥',
        'zoom_api_secret' => 'Zoom API密钥',
        'join_meeting' => '加入会议',
        'start_meeting' => '开始会议',
        'generate_auth_credentials' => '如何生成身份验证凭据？',
        'user_zoom_credential_saved' => '用户Zoom凭据已成功保存。',
        'add_credentials_for_zoom_meeting' => '请添加Zoom会议的凭据。',
        'credentials_already_use' => '您的 Zoom 憑證已被使用',
        'connect_with_zoom' => '您必須連接 Zoom',
        'cannot_delete_meeting_in_progress' => '抱歉，您無法刪除此會議，因為它正在進行中',
        'select_platform' => '选择平台',
    ],

    'vaccination' => [
        'vaccinations' => '預防接種',
        'new_vaccination' => '新疫苗',
        'edit_vaccination' => '編輯疫苗接種',
        'name' => '姓名',
        'manufactured_by' => '製造者',
        'brand' => '品牌',
        'vaccinated' => '已接種疫苗',
    ],

    'vaccinated_patient' => [
        'vaccinated_patient' => '接种疫苗的病人',
        'patient' => '病人',
        'vaccination' => '預防接種',
        'serial_no' => '序列號',
        'does_no' => '劑量',
        'dose_given_date' => '給定劑量',
        'description' => '描述',
        'add_vaccinate_patient' => '添加疫苗接種患者',
        'new_vaccinate_patient' => '新疫苗接種患者',
        'edit_vaccinate_patient' => '編輯疫苗接種患者',
        'vaccine' => '疫苗',
        'vaccinate_patient' => '給病人接種疫苗',
        'already_registered_dose' => '患者已经使用相同的疫苗和剂量进行注册。',
    ],

    'front_setting' => [
        'about_us_title' => '标题',
        'about_us_mission' => '使命',
        'about_us_image' => '图像',
        'about_us_description' => '描述',
        'about_us_details' => '关于我们 详情',
        'appointment_details' => '预约详情',
        'terms_condition_details' => '条款及细则详情',
        'front_setting_details' => '正面设置细节',
        'home_page_image' => '主页图片',
        'home_page_title' => '主页标题',
        'home_page_description' => '主页说明',
        'home_page_box_title' => '主页框标题',
        'home_page_box_description' => '主页框说明',
        'home_page_experience' => '首页体验',
        'home_page_step_1_title' => '主页 步骤 1 标题',
        'home_page_step_1_description' => '主页 步骤 1 说明',
        'home_page_step_2_title' => '主页 步骤 2 标题',
        'home_page_step_2_description' => '主页 步骤 2 说明',
        'home_page_step_3_title' => '主页 步骤 3 标题',
        'home_page_step_3_description' => '主页 步骤 3 说明',
        'home_page_step_4_title' => '主页 步骤 4 标题',
        'home_page_step_4_description' => '主页 步骤 4 说明',
        'terms_conditions' => '条款和条件',
        'privacy_policy' => '隐私政策',
        'home_page_certified_doctor_image' => '首页认证医生形象',
        'home_page_certified_doctor_text' => '主页认证医生文本',
        'home_page_certified_doctor_title' => '主页 认证医生职称',
        'home_page_certified_doctor_description' => '主页 认证医生 说明',
        'home_page_certified_box_title' => '主页认证框标题',
        'home_page_certified_box_description' => '主页 认证框说明',
        'the_terms_conditions_is_required' => '需要接受《服务条款》。',
        'the_privacy_policy_is_required' => '需要接受《隐私政策》。',
        'home_page_experience_required' => '首页经验字段不能仅包含空格。',
        'home_page_title_required' => '首页标题字段不能仅包含空格。',
        'home_page_description_required' => '首页描述字段不能仅包含空格。',
        'home_page_box_required' => '首页盒子标题字段不能仅包含空格。',
        'home_page_box_descriptions_required' => '首页盒子描述字段不能仅包含空格。',
        'home_page_certified_required' => '首页认证医生文本字段不能仅包含空格。',
        'home_page_certified_title_required' => '首页认证医生标题字段不能仅包含空格。',
        'home_page_certified_doctor_description_required' => '首页认证医生描述字段不能仅包含空格。',
        'home_page_certified_box_title_required' => '首页认证盒子标题字段不能仅包含空格。',
        'home_page_certified_description_required' => '首页认证描述字段不能仅包含空格。',
        'home_page_step_title_required' => '首页步骤1标题字段不能仅包含空格。',
        'home_page_step_description_required' => '首页步骤1描述字段不能仅包含空格。',
        'home_page_step_two_title_required' => '首页步骤2标题字段不能仅包含空格。',
        'home_page_step_two_description_required' => '首页步骤2描述字段不能仅包含空格。',
        'home_page_step_three_title_required' => '首页步骤3标题字段不能仅包含空格。',
        'home_page_step_three_description_required' => '首页步骤3描述字段不能仅包含空格。',
        'home_page_step_four_title_required' => '首页步骤4标题字段不能仅包含空格。',
        'home_page_step_four_description_required' => '首页步骤4描述字段不能仅包含空格。',
        'about_us_title_required' => '关于我们标题字段不能仅包含空格。',
        'about_us_description_required' => '关于我们描述字段不能仅包含空格。',
        'about_us_mission_required' => '关于我们使命字段不能仅包含空格。',
    ],

    'change_password' => [
        'change_password' => '更改密码',
        'current_password' => '当前密码',
        'new_password' => '新密码',
        'confirm_password' => '确认密码',
    ],

    'web_home' => [
        'home' => '家',
        'services' => '服务',
        'doctors' => '医生',
        'about_us' => '关于我们',
        'contact' => '接触',
        'make_appointment' => '约个时间',
        'working_hours' => '工作时间',
        'testimonials' => '感言',
        'terms_of_service' => '服务条款',
        'privacy_policy' => '隐私政策',
        'patients' => '耐心',
        'years_experience' => '多年经验',
        'sign_up' => '报名',
        'available_doctors' => '可用医生',
        'select_doctors' => '选择医生',
        'contact_doctors' => '选择医生',
        'contact_hospital' => '联系医院',
        'easy_solutions' => '简单的解决方案',
        '4_easy_step_and_get_the_world_best_treatment' => '4个简单的步骤并获得世界上最好的治疗',
        'book_an_appointment' => '预约',
        'select_doctor' => '选择医生',
        'book_now' => '现在预订',
        'patients_beds' => '病床',
        'doctors_nurses' => '医生和护士',
        'happy_patients' => '快乐的病人',
        'book_appointment' => '预约',
        'our_services' => '我们的服务',
        'we_offer_different_services_to_improve_your_health' => '我们提供不同的服务来改善您的健康',
        'professional_doctors' => '专业医生',
        'we_are_experienced_healthcare_professionals' => '我们是经验丰富的医疗保健专业人员',
        'our_testimonials' => '我们的见证',
        'what_our_patient_say_about_medical_treatments' => '我们的患者对我们的医疗的评价',
        'professional_details' => '专业详情'
    ],

    'web_password' => [
        'please_fill_all_the_required_fields' => '请填写所有必填字段。',
        'password_and_confirm_password_not_match' => '密码和确认密码不匹配。',
    ],

    'web_contact' => [
        'call_today' => '今天打电话',
        'open_hours' => '营业时间',
        'our_location' => '我们的位置',
        'send_us_a_message' => '给我们发信息',
        'your_name' => '你的名字',
        'your_email' => '你的邮件',
        'phone_number' => '电话号码',
        'select_enquiry' => '选择询价',
        'your_message' => '您的留言',
        'send_message' => '发信息',
        'enter_your_name' => '输入你的名字',
        'enter_your_email' => '输入你的电子邮箱',
        'contact_no' => '联系方式',
        'please_enter_your_phone_number' => '请输入您的电话号码',
        'write_your_message' => '写下你的信息',
        'type_your_message' => '输入您的消息',
    ],

    'web_menu' => [
        'about' => '关于',
        'our_features' => '我们的特色',
        'appointment' => '预约',
        'working_hours' => '工作时间',
        'login' => '登录',
        'useful_link' => '有用的链接',
        'contact_information' => '联系信息',
        'copyright' => '版权',
        'all_rights_reserved_by' => '版权所有',
    ],

    'web_appointment' => [
        'make_an_appointment' => '预约',
        'call_now_and_get_a_free_consulting' => '立即致电并获得免费咨询',
        'enter_your_first_name' => '输入您的名字',
        'enter_your_last_name' => '输入您的姓氏',
        'enter_your_password' => '输入您的密码',
        'enter_confirm_password' => '输入确认密码',
        'select_department' => '选择部门',
        'select_doctor' => '选择医生',
        'enter_description' => '输入说明',
        'select_time' => '选择时间',
    ],

    'web_working_hours' => [
        'opening_hours' => '营业时间',
        'no_yet_opening_hours' => '暂无营业时间',
    ],

    'purchase_medicine' => [
        'purchase_number' => '购买数量',
        'total' => '全部的',
        'discount' => '折扣',
        'tax_amount' => '税额',
        'net_amount' => '净额',
        'payment_mode' => '付款方式',
        'payment_note' => '付款单',
        'note' => '笔记',
        'purchase_medicine' => '购买药品',
        'purchase_medicine_details' => '购买药品详情',
        'purchase_medicine_overview' => '采购药品概览',
        'lot_no' => '批号',
        'tax' => '税',
        'quantity' => '数量',
        'amount' => '数量',
        'expiry_date' => '到期日',
        'other_details' => '其他详情',
        'dose_duration' => '剂量持续时间',
        'medicine_purchased_successfully' => '药物购买成功',
    ],

    'used_medicine' => [
        'used_medicine' => '用过的药品',
        'used_quantity' => '使用数量',
        'used_at' => '使用于',
    ],

    'front_services' => [
        'new_service' => '新服務',
        'edit_service' => '編輯服務',
        'select_icon_file' => '請選擇圖示文件',
    ],

    'medicine_bills' => [
        'medicine_bills' => '医药费',
        'medicine_bill' => '医药法案',
        'edit_medicine_bill' => '添加药品账单',
        'medicine_bill_details' => '编辑药品账单',
        'dose_interval' => '药品账单详情',
        'available_quantity' => '剂量间隔',
        'is' => '可用数量',
        'prescription_not_found' => '是',
        'medicine_not_selected' => '未找到处方。',
        'duplicate_medicine' => '请至少选择一种药物。',
        'payment_status' => '不能重复添加药物。',
        'sale_price' => '支付状态',
        'add_medicine_bill' => '销售价格',
        'select_medicine' => '选择药物',
        'update_quantity' => '更新数量应小于之前的数量。',
        'net_amount_not_empty' => '净额不能为空。.',
        'net_amount_not_zero' => '净额不能为零。',
        'medicine_required' => '需要医学领域。',
        'bill_number' => '帐单号码',
        'payment_type' => '付款方式',
        'tax_amount_not_zero_or_empty' => '税额不能为零或为空。',
        'validate_discount' => '折扣应小于总金额。',
        'validate_tax' => '税费应小于100%。',
        'quantity_cannot_be_zero' => '数量不能为零或为空。',
        'lot_number' => '请输入批号',
        'sale_price' => '请输入销售价格',
        'purchase_price' => '请输入采购价格',
        'validate_quantity' => '数量应大于0。',
        'quantity_required' => '请输入数量。',
    ],
    'subscription_plans' => [
        'payment_type' => '选择支付方式',
        'connect_with_zoom' => '连接到Zoom',
        'connected' => '已连接',
    ],

    'holiday' => [
        'holiday' => '假日',
        'add_holiday' => '添加假日',
        'doctor_holiday' => '医生假期',
        'service_category' => '服务类别',
        'holiday_date' => '假日日期',
        'reason' => '原因',
        'holiday_already_is_exist' => '假日已经存在。',
        'doctor_holiday_create' => '医生假期已成功保存。',
        'you_are_not_allow_to_record' => '看起来您无权访问此记录。',
        'appointment_exists' => '已有預約，您無法休假。',
    ],

    'lunch_break' => [
        'lunch_breaks' => '午餐休息',
        'lunch_break' => '午餐休息',
        'break_create' => '成功保存午餐休息。',
        'break_update' => '成功更新午餐休息。',
        'add_break' => '添加午餐休息',
        'edit_break' => '编辑午餐休息',
        'break_already_is_exist' => '午餐休息已经存在。',
        'break_time_greater_than_zero' => '休息时间必须大于零。',
        'break_to_time_greater_than_zero' => '休息结束时间必须大于零。',
        'break_to_time_greater_than_from_time' => '休息结束时间必须大于休息开始时间。',
        'date_required' => '日期欄位為必填項。',
        'appointment_exists' => '已有預約，您不能休息。',
    ],

    'new_change' => [
        'pathology_units' => '病理学单位',
        'pathology_unit' => '病理科',
        'add_unit' => '新病理科',
        'edit_unit' => '编辑病理科',
        'pathology_unit_not_found' => '未找到病理科',
        'pathology_unit_cant_deleted' => '病理单元无法删除。',
        'pathology_parameter_not_found' => '未找到病理参数',
        'pathology_parameter_cant_deleted' => '病理参数无法删除。',
        'pathology_parameter' => '病理参数',
        'pathology_parameters' => '病理参数',
        'add_parameter' => '新病理参数',
        'edit_parameter' => '编辑病理参数',
        'parameter_name_required' => '参数名称字段是必需的。',
        'patient_result_required' => '患者结果字段为必填项。',
        'parameter_name' => '参数名称',
        'patient_result' => '患者结果',
        'select_parameter_name' => '选择参数名称',
        'reference_range' => '参考范围',
        'select_unit' => '选择单位',
        'print_pathology_test' => '打印病理学测试',
        'pathology_test_report' => '病理检测报告',
    ],
    'subscription_plans' => [
        'payment_type' => '选择付款方式',
        'connect_with_zoom' => '连接到 Zoom',
        'connected' => '已连接',
        'select_ipd_patient' => '选择 IPD 患者',
    ],

    'patient_id_card' => [
        'id' => 'ID',
        'patient_id_card' => '患者智慧卡',
        'new_patient_id_card_template' => '新患者智慧卡模板',
        'edit_patient_id_card_template' => '編輯患者智能卡模板',
        'patient_id_card_template' => '患者智慧卡模板',
        'color' => '颜色',
        'patient_unique_id' => '患者唯一标识',
        'new_patient_id_card' => '新患者智能卡',
        'generate_patient_id_card' => '產生患者智慧卡',
        'template_id' => '模板名稱',
        'select_template' => '选择模板',
        'select_type' => '选择类型',
        'all_patient' => '對於所有患者',
        'one_patient' => '名患者',
        'remaining_patients' => '剩餘患者',
        'template_required' => '模板欄位必填',
        'patient_required' => '患者欄位為必填項',
    ],

    'register' => [
        'hello' => '你好！',
        'whoops' => '糟糕！',
        'regards' => '致以问候，',
        'if_having_trouble_text' => "如果您在单击“:actionText”按钮时遇到问题，请复制并粘贴以下网址\n".
        '到您的网络浏览器中：[:actionURL](:actionURL)',
    ],

    'custom_field' => [
        'custom_field' => '自定义字段',
        'add_custom_field' => '添加自定义字段',
        'edit_custom_field' => '编辑自定义字段',
        'module_name' => '模块名称',
        'field_type' => '字段类型',
        'field_name' => '字段名称',
        'grid' => '网格',
        'value' => '数值',
        'seperated_by_comma' => '用逗号分隔',
        'is_reqired' => '是否必填',
        'input' => '输入',
        'textarea' => '文本框',
        'checkbox' => '复选框',
        'number' => '数字',
        'dropdown' => '下拉框',
        'multi_select' => '多选',
        'date' => '日期',
        'date_time' => '约会时间',
        'appointment' => '约会',
        'ipd_patient' => '住院患者',
        'opd_patient' => '门诊患者',
        'patient' => '患者',
        'value_must_be_greter_then' => '值必须大于1',
        'select_module' => '选择模块',
        'select_field_type' => '选择字段类型',
        'text' => '文本'
    ],

    'google_meet' => [
        'connect_calendar' => '連接您的Google日曆',
        'disconnect_google_calendar' => '中斷您的 Google 日曆',
        'sync_google_calendar' => '同步您的Google日曆',
        'validate_json_file' => '請設定您的 Google 日曆憑證 json 文件',
        'google_calendar_connect' => '谷歌日曆連線成功',
        'google_calendar_add' => '日曆新增成功',
        'google_calendar_update' => 'Google 日曆更新成功。',
        'disconnect_or_reconnect' => '請中斷並重新連接您的 Google 日曆',
        'google_calendar_disconnect' => 'Google 日曆已斷開連接',
        'select_google_calendar' => '選擇要在其中建立活動的日曆（來自 Google 日曆）',
        'platform_type' => '平台類型',
        'google_json_file' => 'Google Json 文件',
        'upload_json_file' => '請上傳 JSON 檔案。',
        'upload_file' => '請上傳文件。',
        'invalid_json_format' => '此格式無效，有效格式為 JSON。',
        'json_file_saved_successfully' => 'Google 日曆 Json 檔案保存成功',
    ],

    'footer' => [
        'all_rights_reserved' => '版權所有',
    ],

    'open_ai' => [
        'provide_prompt' => '请提供身体信息以供提示。',
        'open_ai_key_not_found' => '未找到 OpenAI API 密钥。',
        'repsonse_retrive_successfully' => '响应已成功检索。',
        'open_ai_key' => '打开AI钥匙',
        'suggest_medicines' => '建议药物',
    ],

    'schedule_weekday' => [
        'Monday' => '周一',
        'Tuesday' => '周二',
        'Wednesday' => '周三',
        'Thursday' => '周四',
        'Friday' => '星期五',
        'Saturday' => '周六',
        'Sunday' => '星期日',
    ],

    'hospital_schedule_weekday' => [
        'MON' => '星期一',
        'TUE' => '周二',
        'WED' => '星期三',
        'THU' => '周四',
        'FRI' => '周五',
        'SAT' => '坐',
        'SUN' => '太阳',
    ],
];
