<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | The following language lines contain the default error messages used by
    | the validator class. Some of these rules have multiple versions such
    | as the size rules. Feel free to tweak each of these messages here.
    |
    */

    'accepted' => 'Das :attribute muss akzeptiert werden.',
    'active_url' => 'Das :attribute ist keine gültige URL.',
    'after' => 'Das :attribute muss ein Datum nach :date sein.',
    'after_or_equal' => 'Das :attribute muss ein Datum nach oder gleich :date sein.',
    'alpha' => 'Das :attribute darf nur Buchstaben enthalten.',
    'alpha_dash' => 'Das :attribute darf nur Buchstaben, Zahlen, Bindestriche und Unterstriche enthalten.',
    'alpha_num' => 'Das :attribute darf nur Buchstaben und Zahlen enthalten.',
    'array' => 'Das :attribute muss ein Array sein.',
    'before' => 'Das :attribute muss ein Datum vor :date sein.',
    'before_or_equal' => 'Das :attribute muss ein Datum vor oder gleich :date sein.',
    'between' => [
        'numeric' => 'Das :attribute muss zwischen :min und :max.',
        'file' => 'Das :attribute muss zwischen :min und :max Kilobyte.',
        'string' => 'Das :attribute muss zwischen den Zeichen :min und :max.',
        'array' => 'Das :attribute muss zwischen :min und :max Elementen.',
    ],
    'boolean' => 'Das :attribute muss wahr oder falsch sein.',
    'confirmed' => 'Die Bestätigung des :attribute stimmt nicht überein.',
    'date' => 'Das :attribute ist kein gültiges Datum.',
    'date_equals' => 'Das :attribute muss ein Datum sein, das gleich :date ist.',
    'date_format' => 'Das :attribute stimmt nicht mit dem Format :format überein.',
    'different' => 'Das :attribute und :other muss unterschiedlich sein.',
    'digits' => 'Das :attribute muss sein: digits Ziffern.',
    'digits_between' => 'Das :attribute muss zwischen den Ziffern :min und :max liegen.',
    'dimensions' => 'Das :attribute hat ungültige Bildabmessungen.',
    'distinct' => 'Das :attribute hat einen doppelten Wert.',
    'email' => 'Das :attribute muss eine gültige E-Mail-Adresse sein.',
    'ends_with' => 'Das :attribute muss mit einem der folgenden Werte enden :values.',
    'exists' => 'Das :attribute selected ist ungültig.',
    'file' => 'Das :attribute muss eine Datei sein.',
    'filled' => 'Das :attribute muss einen Wert haben.',
    'gt' => [
        'numeric' => 'Das :attribute muss größer als: value sein.',
        'file' => 'Das :attribute muss größer sein als :value Kilobyte.',
        'string' => 'Das :attribute muss größer sein als :value Zeichen.',
        'array' => 'Das :attribute muss mehr als :value-Elemente enthalten.',
    ],
    'gte' => [
        'numeric' => 'Das :attribute muss größer oder gleich :value sein.',
        'file' => 'Das :attribute muss größer oder gleich :value Kilobyte sein.',
        'string' => 'Das :attribute muss größer oder gleich :value zeichen sein.',
        'array' => 'Das :attribute muss mindestens :value-Elemente enthalten.',
    ],
    'image' => 'Das :attribute muss ein Bild sein.',
    'in' => 'Das :attribute selected ist ungültig.',
    'in_array' => 'Das :attribute existiert nicht in :other.',
    'integer' => 'Das :attribute muss eine Ganzzahl sein.',
    'ip' => 'Das :attribute muss eine gültige IP-Adresse sein.',
    'ipv4' => 'Das :attribute muss eine gültige IPv4-Adresse sein.',
    'ipv6' => 'Das :attribute muss eine gültige IPv6-Adresse sein.',
    'json' => 'Das :attribute muss eine gültige JSON-Zeichenfolge sein.',
    'lt' => [
        'numeric' => 'Das :attribute muss kleiner als :value sein.',
        'file' => 'Das :attribute muss kleiner als :value Kilobyte sein.',
        'string' => 'Das :attribute muss kleiner als :value sein.',
        'array' => 'Das :attribute muss weniger als :value-Elemente enthalten.',
    ],
    'lte' => [
        'numeric' => 'Das :attribute muss kleiner oder gleich :value sein.',
        'file' => 'Das :attribute muss kleiner oder gleich :value Kilobyte sein.',
        'string' => 'Das :attribute muss kleiner oder gleich :value zeichen sein.',
        'array' => 'Das :attribute darf nicht mehr als :value-Elemente enthalten.',
    ],
    'max' => [
        'numeric' => 'Das :attribute darf nicht größer sein als :max.',
        'file' => 'Das :attribute darf nicht größer als :max Kilobyte sein.',
        'string' => 'Das :attribute darf nicht größer als :max Zeichen sein.',
        'array' => 'Das :attribute darf nicht mehr als :max Elemente enthalten.',
    ],
    'mimes' => 'Das :attribute muss eine Datei vom Typ :values sein.',
    'mimetypes' => 'Das :attribute muss eine Datei vom Typ :values sein.',
    'min' => [
        'numeric' => 'Das :attribute muss mindestens :min sein.',
        'file' => 'Das :attribute muss mindestens :min Kilobyte betragen.',
        'string' => 'Das :attribute muss mindestens :min Zeichen enthalten.',
        'array' => 'Das :attribute muss mindestens :min Elemente enthalten.',
    ],
    'not_in' => 'Das :attribute selected ist ungültig.',
    'not_regex' => 'Das :attribute ist ungültig.',
    'numeric' => 'Das :attribute muss eine Zahl sein.',
    'password' => 'Das Passwort ist inkorrekt.',
    'present' => 'Das :attribute muss vorhanden sein.',
    'regex' => 'Das :attribute ist ungültig.',
    'required' => 'Das Feld :attribute ist erforderlich.',
    'required_if' => 'Das Feld :attribute ist erforderlich, wenn :other :value ist.',
    'required_unless' => 'Das :attribute ist erforderlich, es sei denn :other befindet sich in :values.',
    'required_with' => 'Das :attribute ist erforderlich, wenn :values vorhanden ist.',
    'required_with_all' => 'Das :attribute ist erforderlich, wenn :value vorhanden sind.',
    'required_without' => 'Das Feld :attribute ist erforderlich, wenn :value nicht vorhanden sind.',
    'required_without_all' => 'Das Feld :attribute ist erforderlich, wenn keiner der :value vorhanden ist.',
    'same' => 'Das :attribute und :other müssen übereinstimmen.',
    'size' => [
        'numeric' => 'Das :attribute muss: size sein.',
        'file' => 'Das :attribute muss: size Kilobyte sein.',
        'string' => 'Das :attribute muss Zeichen der: size sein.',
        'array' => 'Das :attribute muss Elemente der: size enthalten.',
    ],
    'starts_with' => 'Das :attribute muss mit einem der folgenden Werte beginnen :value.',
    'string' => 'Das :attribute muss eine Zeichenfolge sein.',
    'timezone' => 'Das :attribute muss eine gültige Zone sein.',
    'unique' => 'Das :attribute wurde bereits übernommen.',
    'uploaded' => 'Das :attribute konnte nicht hochgeladen werden.',
    'url' => 'Das :attribute ist ungültig.',
    'uuid' => 'Das :attribute muss eine gültige UUID sein.',

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Language Lines
    |--------------------------------------------------------------------------
    |
    | Here you may specify custom validation messages for attributes using the
    | convention "attribute.rule" to name the lines. This makes it quick to
    | specify a specific custom language line for a given attribute rule.
    |
    */

    'custom' => [
        'attribute-name' => [
            'rule-name' => 'benutzerdefinierte Nachricht',
        ],

        //doctor opd charge keys
        'doctor_id' => [
            'unique' => 'Der Name des Arztes wurde bereits vergeben.',
        ],
    ],

    /*
    |--------------------------------------------------------------------------
    | Custom Validation Attributes
    |--------------------------------------------------------------------------
    |
    | The following language lines are used to swap our attribute placeholder
    | with something more reader friendly such as "E-Mail Address" instead
    | of "email". This simply helps us make our message more expressive.
    |
    */

    'attributes' => [
        'email' => __('messages.user.email'),
        'last_name' => __('messages.user.last_name'),
        'first_name' => __('messages.user.first_name'),
        'password' => __('messages.department'),
        'gender' => __('messages.user.gender'),
        'city' => __('messages.user.city'),
        'zip' => __('messages.user.zip'),
        'name' => __('messages.common.name'),
        'status' => __('messages.account.status'),
        'description' => __('messages.account.description'),
        'patient_id' => __('messages.invoice.patient_id'),
        'receipt_no' => __('messages.advanced_payment.receipt_no'),
        'amount' => __('messages.advanced_payment.amount'),
        'date' => __('messages.advanced_payment.date'),
        'vehicle_number' => __('messages.ambulance.vehicle_number'),
        'vehicle_model' => __('messages.ambulance.vehicle_model'),
        'driver_contact' => __('messages.ambulance.driver_contact'),
        'year_made' => __('messages.ambulance.year_made'),
        'driver_license' => __('messages.ambulance.driver_license'),
        'doctor_id' => __('messages.ipd_patient.doctor_id'),
        'opd_date' => __('messages.appointment.opd_date'),
        'bed_type' => __('messages.bed.bed_type'),
        'charge' => __('messages.bed.charge'),
        'bed_id' => __('messages.bed.bed_id'),
        'case_id' => __('messages.bed_assign.case_id'),
        'assign_date' => __('messages.bed_assign.assign_date'),
        'discharge_date' => __('messages.bed_assign.discharge_date'),
        'title' => __('messages.document.title'),
        'bill_date' => __('messages.bill.bill_date'),
        'qty' => __('messages.bill.qty'),
        'price' => __('messages.bill.price'),
        'blood_group' => __('messages.user.blood_group'),
        'remained_bags' => __('messages.hospital_blood_bank.remained_bags'),
        'bags' => __('messages.blood_donation.bags'),
        'last_donate_date' => __('messages.blood_donation.last_donate_date'),
        'issue_date' => __('messages.blood_issue.issue_date'),
        'remarks' => __('messages.blood_issue.remarks'),
        'charge_type' => __('messages.charge_category.charge_type'),
        'code' => __('messages.charge.code'),
        'standard_charge' => __('messages.charge.standard_charge'),
        'currency_name' => __('messages.currency.currency_name'),
        'currency_code' => __('messages.currency.currency_code'),
        'currency_icon' => __('messages.currency.currency_icon'),
        'sr_no' => __('messages.employee_payroll.sr_no'),
        'payroll_id' => __('messages.employee_payroll.payroll_id'),
        'type' => __('messages.account.type'),
        'month' => __('messages.employee_payroll.month'),
        'year' => __('messages.employee_payroll.year'),
        'net_salary' => __('messages.employee_payroll.net_salary'),
        'basic_salary' => __('messages.employee_payroll.basic_salary'),
        'message' => __('messages.enquiry.message'),
        'expense_head' => __('messages.expense.expense_head'),
        'invoice_number' => __('messages.expense.invoice_number'),
        'short_description' => __('messages.short_description'),
        'about_us_title' => __('messages.front_setting.about_us_title'),
        'about_us_mission' => __('messages.front_setting.about_us_mission'),
        'about_us_image' => __('messages.front_setting.about_us_image'),
        'income_head' => __('messages.incomes.income_head'),
        'service_tax' => __('messages.insurance.service_tax'),
        'insurance_no' => __('messages.insurance.insurance_no'),
        'insurance_code' => __('messages.insurance.insurance_code'),
        'discount' => __('messages.insurance.discount'),
        'disease_name' => __('messages.insurance.diseases_name'),
        'disease_charge' => __('messages.insurance.diseases_charge'),
        'invoice_date' => __('messages.invoice.invoice_date'),
        'quantity' => __('messages.service.quantity'),
        'total_payments' => __('messages.dashboard.total_payments'),
        'gross_total' => __('messages.ipd_bill.gross_total'),
        'discount_in_percentage' => __('messages.ipd_bill.discount_in_percentage'),
        'tax_in_percentage' => __('messages.ipd_bill.tax_in_percentage'),
        'other_charges' => __('messages.ipd_bill.other_charges'),
        'net_payable_amount' => __('messages.ipd_bill.net_payable_amount'),
        'charge_type_id' => __('messages.ipd_patient_charges.charge_type_id'),
        'charge_category_id' => __('messages.ipd_patient_charges.charge_category_id'),
        'charge_id' => __('messages.ipd_patient_charges.charge_id'),
        'applied_charge' => __('messages.ipd_patient_charges.applied_charge'),
        'instruction' => __('messages.ipd_patient_consultant_register.instruction'),
        'instruction_date' => __('messages.ipd_patient_consultant_register.instruction_date'),
        'report_type' => __('messages.ipd_patient_diagnosis.report_type'),
        'report_date' => __('messages.ipd_patient_diagnosis.report_date'),
        'bed_type_id' => __('messages.ipd_patient.bed_type_id'),
        'weight' => __('messages.ipd_patient.weight'),
        'height' => __('messages.ipd_patient.height'),
        'bp' => __('messages.ipd_patient.bp'),
        'payment_mode' => __('messages.ipd_payments.payment_mode'),
        'notes' => __('messages.document.notes'),
        'category_id' => __('messages.ipd_patient_prescription.category_id'),
        'issued_by' => __('messages.issued_item.issued_by'),
        'issued_date' => __('messages.issued_item.issued_date'),
        'return_date' => __('messages.issued_item.return_date'),
        'unit' => __('messages.item.unit'),
        'consultation_title' => __('messages.live_consultation.consultation_title'),
        'consultation_date' => __('messages.live_consultation.consultation_date'),
        'consultation_duration_minutes' => __('messages.live_consultation.consultation_duration_minutes'),
        'type_number' => __('messages.live_consultation.type_number'),
        'to' => __('messages.common.to'),
        'subject' => __('messages.email.subject'),
        'selling_price' => __('messages.medicine.selling_price'),
        'buying_price' => __('messages.medicine.buying_price'),
        'side_effects' => __('messages.medicine.side_effects'),
        'salt_composition' => __('messages.medicine.salt_composition'),
        'appointment_date' => __('messages.opd_patient.appointment_date'),
        'rate' => __('messages.package.rate'),
        'test_name' => __('messages.radiology_test.test_name'),
        'short_name' => __('messages.radiology_test.short_name'),
        'test_type' => __('messages.radiology_test.test_type'),
        'policy_no' => __('messages.patient_admission.policy_no'),
        'fee' => __('messages.case.fee'),
        'payment_date' => __('messages.payment.payment_date'),
        'pay_to' => __('messages.payment.pay_to'),
        'from_title' => __('messages.postal.from_title'),
        'to_title' => __('messages.postal.to_title'),
        'reference_no' => __('messages.postal.reference_no'),
        'subcategory' => __('messages.radiology_test.subcategory'),
        'available_on' => __('messages.schedule.available_on'),
        'available_from' => __('messages.schedule.available_from'),
        'available_to' => __('messages.schedule.available_to'),
        'per_patient_time' => __('messages.schedule.per_patient_time'),
        'app_name' => __('messages.setting.app_name'),
        'company_name' => __('messages.setting.company_name'),
        'favicon' => __('messages.setting.favicon'),
        'zoom_api_key' => __('messages.live_consultation.zoom_api_key'),
        'zoom_api_secret' => __('messages.live_consultation.zoom_api_secret'),
        'dose_given_date' => __('messages.vaccinated_patient.dose_given_date'),
        'manufactured_by' => __('messages.vaccination.manufactured_by'),
        'brand' => __('messages.vaccination.brand'),
        'purpose' => __('messages.visitor.purpose'),
        'no_of_person' => __('messages.visitor.number_of_person'),
        'in_time' => __('messages.visitor.in_time'),
        'out_time' => __('messages.visitor.out_time'),
        'field_name' => __('messages.custom_field.field_name')
    ],

];
