<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('radiology_tests', function (Blueprint $table) {
            $table->increments('id');
            $table->string('test_name', 160);
            $table->string('short_name');
            $table->string('test_type');
            $table->unsignedInteger('category_id');
            $table->string('subcategory')->nullable();
            $table->integer('report_days')->nullable();
            $table->unsignedInteger('charge_category_id');
            $table->integer('standard_charge');
            $table->timestamps();

            $table->foreign('category_id')->references('id')->on('radiology_categories')
                ->onDelete('cascade')
                ->onUpdate('cascade');

            $table->foreign('charge_category_id')->references('id')->on('charge_categories')
                ->onDelete('cascade')
                ->onUpdate('cascade');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('radiology_tests');
    }
};
