<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

/**
 * Class PathologyCategory
 *
 * @version April 11, 2020, 5:39 am UTC
 *
 * @property string name
 * @property int $id
 * @property string $name
 * @property \Illuminate\Support\Carbon|null $created_at
 * @property \Illuminate\Support\Carbon|null $updated_at
 *
 * @method static \Illuminate\Database\Eloquent\Builder|PathologyCategory newModelQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PathologyCategory newQuery()
 * @method static \Illuminate\Database\Eloquent\Builder|PathologyCategory query()
 * @method static \Illuminate\Database\Eloquent\Builder|PathologyCategory whereCreatedAt($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PathologyCategory whereId($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PathologyCategory whereName($value)
 * @method static \Illuminate\Database\Eloquent\Builder|PathologyCategory whereUpdatedAt($value)
 *
 * @mixin \Eloquent
 */
class PathologyCategory extends Model
{
    public $table = 'pathology_categories';

    public $fillable = [
        'name',
    ];

    protected $casts = [
        'id' => 'integer',
        'name' => 'string',
    ];

    public static $rules = [
        'name' => 'required|unique:pathology_categories,name',
    ];
}
